<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dictionary StructType
 * Meta information extracted from the WSDL
 * - type: tns:Dictionary
 * @subpackage Structs
 */
class Dictionary extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DictionaryValue[]
     */
    public $Value;
    /**
     * Constructor method for Dictionary
     * @uses Dictionary::setCode()
     * @uses Dictionary::setValue()
     * @param string $code
     * @param \StructType\DictionaryValue[] $value
     */
    public function __construct($code = null, array $value = array())
    {
        $this
            ->setCode($code)
            ->setValue($value);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Dictionary
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Value value
     * @return \StructType\DictionaryValue[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dictionaryValueItem) {
            // validation for constraint: itemType
            if (!$dictionaryValueItem instanceof \StructType\DictionaryValue) {
                $invalidValues[] = is_object($dictionaryValueItem) ? get_class($dictionaryValueItem) : sprintf('%s(%s)', gettype($dictionaryValueItem), var_export($dictionaryValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \StructType\DictionaryValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param \StructType\DictionaryValue[] $value
     * @return \StructType\Dictionary
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \StructType\DictionaryValue $item
     * @return \StructType\Dictionary
     */
    public function addToValue(\StructType\DictionaryValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DictionaryValue) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type \StructType\DictionaryValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
