<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerConractInfo StructType
 * Meta information extracted from the WSDL
 * - type: tns:DealerConractInfo
 * @subpackage Structs
 */
class DealerConractInfo extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The agentConract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AgentConract
     */
    public $agentConract;
    /**
     * The generalConract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GeneralConract
     */
    public $generalConract;
    /**
     * The dealer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $dealer;
    /**
     * Constructor method for DealerConractInfo
     * @uses DealerConractInfo::setType()
     * @uses DealerConractInfo::setAgentConract()
     * @uses DealerConractInfo::setGeneralConract()
     * @uses DealerConractInfo::setDealer()
     * @param string $type
     * @param \StructType\AgentConract $agentConract
     * @param \StructType\GeneralConract $generalConract
     * @param \StructType\SubjectInfo $dealer
     */
    public function __construct($type = null, \StructType\AgentConract $agentConract = null, \StructType\GeneralConract $generalConract = null, \StructType\SubjectInfo $dealer = null)
    {
        $this
            ->setType($type)
            ->setAgentConract($agentConract)
            ->setGeneralConract($generalConract)
            ->setDealer($dealer);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\DealerConractType::valueIsValid()
     * @uses \EnumType\DealerConractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DealerConractInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DealerConractType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DealerConractType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\DealerConractType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get agentConract value
     * @return \StructType\AgentConract|null
     */
    public function getAgentConract()
    {
        return $this->agentConract;
    }
    /**
     * Set agentConract value
     * @param \StructType\AgentConract $agentConract
     * @return \StructType\DealerConractInfo
     */
    public function setAgentConract(\StructType\AgentConract $agentConract = null)
    {
        $this->agentConract = $agentConract;
        return $this;
    }
    /**
     * Get generalConract value
     * @return \StructType\GeneralConract|null
     */
    public function getGeneralConract()
    {
        return $this->generalConract;
    }
    /**
     * Set generalConract value
     * @param \StructType\GeneralConract $generalConract
     * @return \StructType\DealerConractInfo
     */
    public function setGeneralConract(\StructType\GeneralConract $generalConract = null)
    {
        $this->generalConract = $generalConract;
        return $this;
    }
    /**
     * Get dealer value
     * @return \StructType\SubjectInfo|null
     */
    public function getDealer()
    {
        return $this->dealer;
    }
    /**
     * Set dealer value
     * @param \StructType\SubjectInfo $dealer
     * @return \StructType\DealerConractInfo
     */
    public function setDealer(\StructType\SubjectInfo $dealer = null)
    {
        $this->dealer = $dealer;
        return $this;
    }
}
