<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyExch StructType
 * @subpackage Structs
 */
class CurrencyExch extends AbstractStructBase
{
    /**
     * The currCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currCode;
    /**
     * The currExchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $currExchValue;
    /**
     * Constructor method for CurrencyExch
     * @uses CurrencyExch::setCurrCode()
     * @uses CurrencyExch::setCurrExchValue()
     * @param string $currCode
     * @param float $currExchValue
     */
    public function __construct($currCode = null, $currExchValue = null)
    {
        $this
            ->setCurrCode($currCode)
            ->setCurrExchValue($currExchValue);
    }
    /**
     * Get currCode value
     * @return string|null
     */
    public function getCurrCode()
    {
        return $this->currCode;
    }
    /**
     * Set currCode value
     * @param string $currCode
     * @return \StructType\CurrencyExch
     */
    public function setCurrCode($currCode = null)
    {
        // validation for constraint: string
        if (!is_null($currCode) && !is_string($currCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currCode, true), gettype($currCode)), __LINE__);
        }
        $this->currCode = $currCode;
        return $this;
    }
    /**
     * Get currExchValue value
     * @return float|null
     */
    public function getCurrExchValue()
    {
        return $this->currExchValue;
    }
    /**
     * Set currExchValue value
     * @param float $currExchValue
     * @return \StructType\CurrencyExch
     */
    public function setCurrExchValue($currExchValue = null)
    {
        // validation for constraint: float
        if (!is_null($currExchValue) && !(is_float($currExchValue) || is_numeric($currExchValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currExchValue, true), gettype($currExchValue)), __LINE__);
        }
        $this->currExchValue = $currExchValue;
        return $this;
    }
}
