<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPerson StructType
 * @subpackage Structs
 */
class ContactPerson extends AbstractStructBase
{
    /**
     * The person
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PhysicalSubject
     */
    public $person;
    /**
     * The officialCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $officialCapacity;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * Constructor method for ContactPerson
     * @uses ContactPerson::setPerson()
     * @uses ContactPerson::setOfficialCapacity()
     * @uses ContactPerson::setNotes()
     * @param \StructType\PhysicalSubject $person
     * @param string $officialCapacity
     * @param string $notes
     */
    public function __construct(\StructType\PhysicalSubject $person = null, $officialCapacity = null, $notes = null)
    {
        $this
            ->setPerson($person)
            ->setOfficialCapacity($officialCapacity)
            ->setNotes($notes);
    }
    /**
     * Get person value
     * @return \StructType\PhysicalSubject|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \StructType\PhysicalSubject $person
     * @return \StructType\ContactPerson
     */
    public function setPerson(\StructType\PhysicalSubject $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Get officialCapacity value
     * @return string|null
     */
    public function getOfficialCapacity()
    {
        return $this->officialCapacity;
    }
    /**
     * Set officialCapacity value
     * @param string $officialCapacity
     * @return \StructType\ContactPerson
     */
    public function setOfficialCapacity($officialCapacity = null)
    {
        // validation for constraint: string
        if (!is_null($officialCapacity) && !is_string($officialCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officialCapacity, true), gettype($officialCapacity)), __LINE__);
        }
        $this->officialCapacity = $officialCapacity;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \StructType\ContactPerson
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
}
