<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalcPolicyResult StructType
 * @subpackage Structs
 */
class CalcPolicyResult extends AbstractStructBase
{
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * The paramDefaultValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParamDefaultValuesList
     */
    public $paramDefaultValues;
    /**
     * The warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $warnings;
    /**
     * Constructor method for CalcPolicyResult
     * @uses CalcPolicyResult::setUrl()
     * @uses CalcPolicyResult::setPolicy()
     * @uses CalcPolicyResult::setErrors()
     * @uses CalcPolicyResult::setParamDefaultValues()
     * @uses CalcPolicyResult::setWarnings()
     * @param string $url
     * @param \StructType\Policy $policy
     * @param \StructType\ErrorList $errors
     * @param \StructType\ParamDefaultValuesList $paramDefaultValues
     * @param \StructType\ErrorList $warnings
     */
    public function __construct($url = null, \StructType\Policy $policy = null, \StructType\ErrorList $errors = null, \StructType\ParamDefaultValuesList $paramDefaultValues = null, \StructType\ErrorList $warnings = null)
    {
        $this
            ->setUrl($url)
            ->setPolicy($policy)
            ->setErrors($errors)
            ->setParamDefaultValues($paramDefaultValues)
            ->setWarnings($warnings);
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\CalcPolicyResult
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\CalcPolicyResult
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\CalcPolicyResult
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get paramDefaultValues value
     * @return \StructType\ParamDefaultValuesList|null
     */
    public function getParamDefaultValues()
    {
        return $this->paramDefaultValues;
    }
    /**
     * Set paramDefaultValues value
     * @param \StructType\ParamDefaultValuesList $paramDefaultValues
     * @return \StructType\CalcPolicyResult
     */
    public function setParamDefaultValues(\StructType\ParamDefaultValuesList $paramDefaultValues = null)
    {
        $this->paramDefaultValues = $paramDefaultValues;
        return $this;
    }
    /**
     * Get warnings value
     * @return \StructType\ErrorList|null
     */
    public function getWarnings()
    {
        return $this->warnings;
    }
    /**
     * Set warnings value
     * @param \StructType\ErrorList $warnings
     * @return \StructType\CalcPolicyResult
     */
    public function setWarnings(\StructType\ErrorList $warnings = null)
    {
        $this->warnings = $warnings;
        return $this;
    }
}
