<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessLicenseList StructType
 * @subpackage Structs
 */
class BusinessLicenseList extends AbstractStructBase
{
    /**
     * The license
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessLicense[]
     */
    public $license;
    /**
     * Constructor method for BusinessLicenseList
     * @uses BusinessLicenseList::setLicense()
     * @param \StructType\BusinessLicense[] $license
     */
    public function __construct(array $license = array())
    {
        $this
            ->setLicense($license);
    }
    /**
     * Get license value
     * @return \StructType\BusinessLicense[]|null
     */
    public function getLicense()
    {
        return $this->license;
    }
    /**
     * This method is responsible for validating the values passed to the setLicense method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLicense method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLicenseForArrayConstraintsFromSetLicense(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessLicenseListLicenseItem) {
            // validation for constraint: itemType
            if (!$businessLicenseListLicenseItem instanceof \StructType\BusinessLicense) {
                $invalidValues[] = is_object($businessLicenseListLicenseItem) ? get_class($businessLicenseListLicenseItem) : sprintf('%s(%s)', gettype($businessLicenseListLicenseItem), var_export($businessLicenseListLicenseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The license property can only contain items of type \StructType\BusinessLicense, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set license value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessLicense[] $license
     * @return \StructType\BusinessLicenseList
     */
    public function setLicense(array $license = array())
    {
        // validation for constraint: array
        if ('' !== ($licenseArrayErrorMessage = self::validateLicenseForArrayConstraintsFromSetLicense($license))) {
            throw new \InvalidArgumentException($licenseArrayErrorMessage, __LINE__);
        }
        $this->license = $license;
        return $this;
    }
    /**
     * Add item to license value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessLicense $item
     * @return \StructType\BusinessLicenseList
     */
    public function addToLicense(\StructType\BusinessLicense $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessLicense) {
            throw new \InvalidArgumentException(sprintf('The license property can only contain items of type \StructType\BusinessLicense, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->license[] = $item;
        return $this;
    }
}
