<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlankList StructType
 * @subpackage Structs
 */
class BlankList extends AbstractStructBase
{
    /**
     * The blanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BlankEntry[]
     */
    public $blanks;
    /**
     * Constructor method for BlankList
     * @uses BlankList::setBlanks()
     * @param \StructType\BlankEntry[] $blanks
     */
    public function __construct(array $blanks = array())
    {
        $this
            ->setBlanks($blanks);
    }
    /**
     * Get blanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BlankEntry[]|null
     */
    public function getBlanks()
    {
        return isset($this->blanks) ? $this->blanks : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBlanks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlanks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBlanksForArrayConstraintsFromSetBlanks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $blankListBlanksItem) {
            // validation for constraint: itemType
            if (!$blankListBlanksItem instanceof \StructType\BlankEntry) {
                $invalidValues[] = is_object($blankListBlanksItem) ? get_class($blankListBlanksItem) : sprintf('%s(%s)', gettype($blankListBlanksItem), var_export($blankListBlanksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The blanks property can only contain items of type \StructType\BlankEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set blanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BlankEntry[] $blanks
     * @return \StructType\BlankList
     */
    public function setBlanks(array $blanks = array())
    {
        // validation for constraint: array
        if ('' !== ($blanksArrayErrorMessage = self::validateBlanksForArrayConstraintsFromSetBlanks($blanks))) {
            throw new \InvalidArgumentException($blanksArrayErrorMessage, __LINE__);
        }
        if (is_null($blanks) || (is_array($blanks) && empty($blanks))) {
            unset($this->blanks);
        } else {
            $this->blanks = $blanks;
        }
        return $this;
    }
    /**
     * Add item to blanks value
     * @throws \InvalidArgumentException
     * @param \StructType\BlankEntry $item
     * @return \StructType\BlankList
     */
    public function addToBlanks(\StructType\BlankEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BlankEntry) {
            throw new \InvalidArgumentException(sprintf('The blanks property can only contain items of type \StructType\BlankEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->blanks[] = $item;
        return $this;
    }
}
