<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficiary StructType
 * @subpackage Structs
 */
class Beneficiary extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $subject;
    /**
     * The degreeOfRelation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $degreeOfRelation;
    /**
     * Constructor method for Beneficiary
     * @uses Beneficiary::setNumber()
     * @uses Beneficiary::setSubject()
     * @uses Beneficiary::setDegreeOfRelation()
     * @param int $number
     * @param \StructType\SubjectInfo $subject
     * @param string $degreeOfRelation
     */
    public function __construct($number = null, \StructType\SubjectInfo $subject = null, $degreeOfRelation = null)
    {
        $this
            ->setNumber($number)
            ->setSubject($subject)
            ->setDegreeOfRelation($degreeOfRelation);
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\Beneficiary
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get subject value
     * @return \StructType\SubjectInfo|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param \StructType\SubjectInfo $subject
     * @return \StructType\Beneficiary
     */
    public function setSubject(\StructType\SubjectInfo $subject = null)
    {
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get degreeOfRelation value
     * @return string|null
     */
    public function getDegreeOfRelation()
    {
        return $this->degreeOfRelation;
    }
    /**
     * Set degreeOfRelation value
     * @param string $degreeOfRelation
     * @return \StructType\Beneficiary
     */
    public function setDegreeOfRelation($degreeOfRelation = null)
    {
        // validation for constraint: string
        if (!is_null($degreeOfRelation) && !is_string($degreeOfRelation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($degreeOfRelation, true), gettype($degreeOfRelation)), __LINE__);
        }
        $this->degreeOfRelation = $degreeOfRelation;
        return $this;
    }
}
