<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankRequisitesList StructType
 * @subpackage Structs
 */
class BankRequisitesList extends AbstractStructBase
{
    /**
     * The requisites
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BankRequisites[]
     */
    public $requisites;
    /**
     * Constructor method for BankRequisitesList
     * @uses BankRequisitesList::setRequisites()
     * @param \StructType\BankRequisites[] $requisites
     */
    public function __construct(array $requisites = array())
    {
        $this
            ->setRequisites($requisites);
    }
    /**
     * Get requisites value
     * @return \StructType\BankRequisites[]|null
     */
    public function getRequisites()
    {
        return $this->requisites;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisites method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisites method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisitesForArrayConstraintsFromSetRequisites(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankRequisitesListRequisitesItem) {
            // validation for constraint: itemType
            if (!$bankRequisitesListRequisitesItem instanceof \StructType\BankRequisites) {
                $invalidValues[] = is_object($bankRequisitesListRequisitesItem) ? get_class($bankRequisitesListRequisitesItem) : sprintf('%s(%s)', gettype($bankRequisitesListRequisitesItem), var_export($bankRequisitesListRequisitesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The requisites property can only contain items of type \StructType\BankRequisites, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set requisites value
     * @throws \InvalidArgumentException
     * @param \StructType\BankRequisites[] $requisites
     * @return \StructType\BankRequisitesList
     */
    public function setRequisites(array $requisites = array())
    {
        // validation for constraint: array
        if ('' !== ($requisitesArrayErrorMessage = self::validateRequisitesForArrayConstraintsFromSetRequisites($requisites))) {
            throw new \InvalidArgumentException($requisitesArrayErrorMessage, __LINE__);
        }
        $this->requisites = $requisites;
        return $this;
    }
    /**
     * Add item to requisites value
     * @throws \InvalidArgumentException
     * @param \StructType\BankRequisites $item
     * @return \StructType\BankRequisitesList
     */
    public function addToRequisites(\StructType\BankRequisites $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankRequisites) {
            throw new \InvalidArgumentException(sprintf('The requisites property can only contain items of type \StructType\BankRequisites, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->requisites[] = $item;
        return $this;
    }
}
