<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachDocumentResponse StructType
 * @subpackage Structs
 */
class AttachDocumentResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The docID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $docID;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * Constructor method for AttachDocumentResponse
     * @uses AttachDocumentResponse::setAccID()
     * @uses AttachDocumentResponse::setDocID()
     * @uses AttachDocumentResponse::setErrors()
     * @param string $accID
     * @param int $docID
     * @param \StructType\ErrorList $errors
     */
    public function __construct($accID = null, $docID = null, \StructType\ErrorList $errors = null)
    {
        $this
            ->setAccID($accID)
            ->setDocID($docID)
            ->setErrors($errors);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\AttachDocumentResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get docID value
     * @return int|null
     */
    public function getDocID()
    {
        return $this->docID;
    }
    /**
     * Set docID value
     * @param int $docID
     * @return \StructType\AttachDocumentResponse
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: int
        if (!is_null($docID) && !(is_int($docID) || ctype_digit($docID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->docID = $docID;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\AttachDocumentResponse
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
}
