<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachDocumentRequest StructType
 * @subpackage Structs
 */
class AttachDocumentRequest extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The calcID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcID;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fileName;
    /**
     * The docID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $docID;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attachment;
    /**
     * Constructor method for AttachDocumentRequest
     * @uses AttachDocumentRequest::setAccID()
     * @uses AttachDocumentRequest::setCalcID()
     * @uses AttachDocumentRequest::setFileName()
     * @uses AttachDocumentRequest::setDocID()
     * @uses AttachDocumentRequest::setType()
     * @uses AttachDocumentRequest::setComment()
     * @uses AttachDocumentRequest::setAttachment()
     * @param string $accID
     * @param string $calcID
     * @param string $fileName
     * @param int $docID
     * @param string $type
     * @param string $comment
     * @param string $attachment
     */
    public function __construct($accID = null, $calcID = null, $fileName = null, $docID = null, $type = null, $comment = null, $attachment = null)
    {
        $this
            ->setAccID($accID)
            ->setCalcID($calcID)
            ->setFileName($fileName)
            ->setDocID($docID)
            ->setType($type)
            ->setComment($comment)
            ->setAttachment($attachment);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\AttachDocumentRequest
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get calcID value
     * @return string|null
     */
    public function getCalcID()
    {
        return $this->calcID;
    }
    /**
     * Set calcID value
     * @param string $calcID
     * @return \StructType\AttachDocumentRequest
     */
    public function setCalcID($calcID = null)
    {
        // validation for constraint: string
        if (!is_null($calcID) && !is_string($calcID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcID, true), gettype($calcID)), __LINE__);
        }
        $this->calcID = $calcID;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\AttachDocumentRequest
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get docID value
     * @return int|null
     */
    public function getDocID()
    {
        return $this->docID;
    }
    /**
     * Set docID value
     * @param int $docID
     * @return \StructType\AttachDocumentRequest
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: int
        if (!is_null($docID) && !(is_int($docID) || ctype_digit($docID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->docID = $docID;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\AttachDocumentRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\AttachDocumentRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @param string $attachment
     * @return \StructType\AttachDocumentRequest
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
}
