<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Print ServiceType
 * @subpackage Services
 */
class _Print extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named printPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrintPolicyRequest $printPolicy
     * @return \StructType\PrintPolicyResponse|bool
     */
    public function printPolicy(\StructType\PrintPolicyRequest $printPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->printPolicy($printPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named printPolicyByState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrintPolicyRequest $printPolicyByState
     * @return \StructType\PrintPolicyResponse|bool
     */
    public function printPolicyByState(\StructType\PrintPolicyRequest $printPolicyByState)
    {
        try {
            $this->setResult($this->getSoapClient()->printPolicyByState($printPolicyByState));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrintPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
