<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Issue ServiceType
 * @subpackage Services
 */
class Issue extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named issuePolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IssuePolicyRequest $issuePolicy
     * @return \StructType\IssuePolicyResponse|bool
     */
    public function issuePolicy(\StructType\IssuePolicyRequest $issuePolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->issuePolicy($issuePolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named issuePolicyAsync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IssuePolicyAsyncRequest $issuePolicyAsync
     * @return \StructType\IssuePolicyAsyncResponse|bool
     */
    public function issuePolicyAsync(\StructType\IssuePolicyAsyncRequest $issuePolicyAsync)
    {
        try {
            $this->setResult($this->getSoapClient()->issuePolicyAsync($issuePolicyAsync));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IssuePolicyAsyncResponse|\StructType\IssuePolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
