<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hide ServiceType
 * @subpackage Services
 */
class Hide extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hideLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HideLoginRequest $hideLogin
     * @return \StructType\HideLoginResponse|bool
     */
    public function hideLogin(\StructType\HideLoginRequest $hideLogin)
    {
        try {
            $this->setResult($this->getSoapClient()->hideLogin($hideLogin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HideLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
