<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getDictionaries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionaries $parameters
     * @return \StructType\GetDictionariesResponse|bool
     */
    public function getDictionaries(\StructType\GetDictionaries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyRequest $getPolicy
     * @return \StructType\GetPolicyResponse|bool
     */
    public function getPolicy(\StructType\GetPolicyRequest $getPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicy($getPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaymentURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaymentURLRequest $getPaymentURL
     * @return \StructType\GetPaymentURLResponse|bool
     */
    public function getPaymentURL(\StructType\GetPaymentURLRequest $getPaymentURL)
    {
        try {
            $this->setResult($this->getSoapClient()->getPaymentURL($getPaymentURL));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaryAttributeValueByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionaryAttributeValueByCode $parameters
     * @return \StructType\GetDictionaryAttributeValueByCodeResponse|bool
     */
    public function getDictionaryAttributeValueByCode(\StructType\GetDictionaryAttributeValueByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaryAttributeValueByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaryValueCodesByAttribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionaryValueCodesByAttribute $parameters
     * @return \StructType\GetDictionaryValueCodesByAttributeResponse|bool
     */
    public function getDictionaryValueCodesByAttribute(\StructType\GetDictionaryValueCodesByAttribute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaryValueCodesByAttribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIssueProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIssueProcessStatusRequest $getIssueProcessStatus
     * @return \StructType\GetIssueProcessStatusResponse|bool
     */
    public function getIssueProcessStatus(\StructType\GetIssueProcessStatusRequest $getIssueProcessStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->getIssueProcessStatus($getIssueProcessStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHashByPolicyCalcId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestsReplacePolicyOwnerRequest $getHashByPolicyCalcId
     * @return \StructType\RequestsReplacePolicyOwnerResponse|bool
     */
    public function getHashByPolicyCalcId(\StructType\RequestsReplacePolicyOwnerRequest $getHashByPolicyCalcId)
    {
        try {
            $this->setResult($this->getSoapClient()->getHashByPolicyCalcId($getHashByPolicyCalcId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllDictionariesExcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDictionariesExcel $parameters
     * @return \StructType\GetAllDictionariesExcelResponse|bool
     */
    public function getAllDictionariesExcel(\StructType\GetAllDictionariesExcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllDictionariesExcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaryByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionaryByCode $parameters
     * @return \StructType\GetDictionaryByCodeResponse|bool
     */
    public function getDictionaryByCode(\StructType\GetDictionaryByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaryByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllDictionariesExcelResponse|\StructType\GetDictionariesResponse|\StructType\GetDictionaryAttributeValueByCodeResponse|\StructType\GetDictionaryByCodeResponse|\StructType\GetDictionaryValueCodesByAttributeResponse|\StructType\GetIssueProcessStatusResponse|\StructType\GetPaymentURLResponse|\StructType\GetPolicyResponse|\StructType\RequestsReplacePolicyOwnerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
