<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dissolution ServiceType
 * @subpackage Services
 */
class Dissolution extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named dissolutionPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DissolutionPolicyRequest $dissolutionPolicy
     * @return \StructType\DissolutionPolicyResponse|bool
     */
    public function dissolutionPolicy(\StructType\DissolutionPolicyRequest $dissolutionPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->dissolutionPolicy($dissolutionPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DissolutionPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
