<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Attach ServiceType
 * @subpackage Services
 */
class Attach extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named attachDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachDocumentRequest $attachDocument
     * @return \StructType\AttachDocumentResponse|bool
     */
    public function attachDocument(\StructType\AttachDocumentRequest $attachDocument)
    {
        try {
            $this->setResult($this->getSoapClient()->attachDocument($attachDocument));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AttachDocumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
