<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for issueProcessState EnumType
 * @subpackage Enumerations
 */
class IssueProcessState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ISSUE_PREPARATION'
     * @return string 'ISSUE_PREPARATION'
     */
    const VALUE_ISSUE_PREPARATION = 'ISSUE_PREPARATION';
    /**
     * Constant for value 'PAYMENT_PREPARATION'
     * @return string 'PAYMENT_PREPARATION'
     */
    const VALUE_PAYMENT_PREPARATION = 'PAYMENT_PREPARATION';
    /**
     * Constant for value 'PAYMENT_WAITING'
     * @return string 'PAYMENT_WAITING'
     */
    const VALUE_PAYMENT_WAITING = 'PAYMENT_WAITING';
    /**
     * Constant for value 'ISSUE_FINALIZATION'
     * @return string 'ISSUE_FINALIZATION'
     */
    const VALUE_ISSUE_FINALIZATION = 'ISSUE_FINALIZATION';
    /**
     * Constant for value 'ISSUE_SUCCESSFUL'
     * @return string 'ISSUE_SUCCESSFUL'
     */
    const VALUE_ISSUE_SUCCESSFUL = 'ISSUE_SUCCESSFUL';
    /**
     * Constant for value 'ISSUE_ERROR'
     * @return string 'ISSUE_ERROR'
     */
    const VALUE_ISSUE_ERROR = 'ISSUE_ERROR';
    /**
     * Return allowed values
     * @uses self::VALUE_ISSUE_PREPARATION
     * @uses self::VALUE_PAYMENT_PREPARATION
     * @uses self::VALUE_PAYMENT_WAITING
     * @uses self::VALUE_ISSUE_FINALIZATION
     * @uses self::VALUE_ISSUE_SUCCESSFUL
     * @uses self::VALUE_ISSUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ISSUE_PREPARATION,
            self::VALUE_PAYMENT_PREPARATION,
            self::VALUE_PAYMENT_WAITING,
            self::VALUE_ISSUE_FINALIZATION,
            self::VALUE_ISSUE_SUCCESSFUL,
            self::VALUE_ISSUE_ERROR,
        );
    }
}
