<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherFromCustomerKey SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetVoucherFromCustomerKey extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The customerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerKey;
    /**
     * Constructor method for GetVoucherFromCustomerKey
     * @uses SpeedexGetVoucherFromCustomerKey::setSessionID()
     * @uses SpeedexGetVoucherFromCustomerKey::setCustomerKey()
     * @param string $sessionID
     * @param string $customerKey
     */
    public function __construct($sessionID = null, $customerKey = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKey
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get customerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->customerKey;
    }
    /**
     * Set customerKey value
     * @param string $customerKey
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKey
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->customerKey = $customerKey;
        return $this;
    }
}
