<?php

namespace Speedex\SpeedexArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBranch SpeedexArray
 * @package Speedex
 * @subpackage Arrays
 */
class SpeedexArrayOfBranch extends AbstractStructArrayBase
{
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Speedex\SpeedexStruct\SpeedexBranch[]
     */
    public $Branch;
    /**
     * Constructor method for ArrayOfBranch
     * @uses SpeedexArrayOfBranch::setBranch()
     * @param \Speedex\SpeedexStruct\SpeedexBranch[] $branch
     */
    public function __construct(array $branch = array())
    {
        $this
            ->setBranch($branch);
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Speedex\SpeedexStruct\SpeedexBranch[]|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBranch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBranch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBranchForArrayConstraintsFromSetBranch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBranchBranchItem) {
            // validation for constraint: itemType
            if (!$arrayOfBranchBranchItem instanceof \Speedex\SpeedexStruct\SpeedexBranch) {
                $invalidValues[] = is_object($arrayOfBranchBranchItem) ? get_class($arrayOfBranchBranchItem) : sprintf('%s(%s)', gettype($arrayOfBranchBranchItem), var_export($arrayOfBranchBranchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Branch property can only contain items of type \Speedex\SpeedexStruct\SpeedexBranch, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexBranch[] $branch
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBranch
     */
    public function setBranch(array $branch = array())
    {
        // validation for constraint: array
        if ('' !== ($branchArrayErrorMessage = self::validateBranchForArrayConstraintsFromSetBranch($branch))) {
            throw new \InvalidArgumentException($branchArrayErrorMessage, __LINE__);
        }
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Add item to Branch value
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexBranch $item
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBranch
     */
    public function addToBranch(\Speedex\SpeedexStruct\SpeedexBranch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Speedex\SpeedexStruct\SpeedexBranch) {
            throw new \InvalidArgumentException(sprintf('The Branch property can only contain items of type \Speedex\SpeedexStruct\SpeedexBranch, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Branch[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Speedex\SpeedexStruct\SpeedexBranch|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Speedex\SpeedexStruct\SpeedexBranch|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Speedex\SpeedexStruct\SpeedexBranch|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Speedex\SpeedexStruct\SpeedexBranch|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Speedex\SpeedexStruct\SpeedexBranch|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Branch
     */
    public function getAttributeName()
    {
        return 'Branch';
    }
}
