<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSessionResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCreateSessionResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionId;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreateSessionResponse
     * @uses SpeedexCreateSessionResponse::setReturnCode()
     * @uses SpeedexCreateSessionResponse::setSessionId()
     * @uses SpeedexCreateSessionResponse::setReturnMessage()
     * @param int $returnCode
     * @param string $sessionId
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, $sessionId = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setSessionId($sessionId)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexCreateSessionResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get sessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \Speedex\SpeedexStruct\SpeedexCreateSessionResponse
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexCreateSessionResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
