<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderLastCheckpoint SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetOrderLastCheckpoint extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The orderid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderid;
    /**
     * Constructor method for GetOrderLastCheckpoint
     * @uses SpeedexGetOrderLastCheckpoint::setSessionID()
     * @uses SpeedexGetOrderLastCheckpoint::setOrderid()
     * @param string $sessionID
     * @param string $orderid
     */
    public function __construct($sessionID = null, $orderid = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setOrderid($orderid);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpoint
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get orderid value
     * @return string|null
     */
    public function getOrderid()
    {
        return $this->orderid;
    }
    /**
     * Set orderid value
     * @param string $orderid
     * @return \Speedex\SpeedexStruct\SpeedexGetOrderLastCheckpoint
     */
    public function setOrderid($orderid = null)
    {
        // validation for constraint: string
        if (!is_null($orderid) && !is_string($orderid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderid, true), gettype($orderid)), __LINE__);
        }
        $this->orderid = $orderid;
        return $this;
    }
}
