<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePickupResult SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCreatePickupResult extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * Constructor method for CreatePickupResult
     * @uses SpeedexCreatePickupResult::setStatusCode()
     * @uses SpeedexCreatePickupResult::setMessage()
     * @uses SpeedexCreatePickupResult::setResult()
     * @param int $statusCode
     * @param string $message
     * @param string $result
     */
    public function __construct($statusCode = null, $message = null, $result = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setMessage($message)
            ->setResult($result);
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupResult
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
