<?php

namespace Speedex\SpeedexArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBOLOrder SpeedexArray
 * @package Speedex
 * @subpackage Arrays
 */
class SpeedexArrayOfBOLOrder extends AbstractStructArrayBase
{
    /**
     * The BOLOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Speedex\SpeedexStruct\SpeedexBOLOrder[]
     */
    public $BOLOrder;
    /**
     * Constructor method for ArrayOfBOLOrder
     * @uses SpeedexArrayOfBOLOrder::setBOLOrder()
     * @param \Speedex\SpeedexStruct\SpeedexBOLOrder[] $bOLOrder
     */
    public function __construct(array $bOLOrder = array())
    {
        $this
            ->setBOLOrder($bOLOrder);
    }
    /**
     * Get BOLOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Speedex\SpeedexStruct\SpeedexBOLOrder[]|null
     */
    public function getBOLOrder()
    {
        return isset($this->BOLOrder) ? $this->BOLOrder : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBOLOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBOLOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBOLOrderForArrayConstraintsFromSetBOLOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBOLOrderBOLOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfBOLOrderBOLOrderItem instanceof \Speedex\SpeedexStruct\SpeedexBOLOrder) {
                $invalidValues[] = is_object($arrayOfBOLOrderBOLOrderItem) ? get_class($arrayOfBOLOrderBOLOrderItem) : sprintf('%s(%s)', gettype($arrayOfBOLOrderBOLOrderItem), var_export($arrayOfBOLOrderBOLOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BOLOrder property can only contain items of type \Speedex\SpeedexStruct\SpeedexBOLOrder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BOLOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexBOLOrder[] $bOLOrder
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBOLOrder
     */
    public function setBOLOrder(array $bOLOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($bOLOrderArrayErrorMessage = self::validateBOLOrderForArrayConstraintsFromSetBOLOrder($bOLOrder))) {
            throw new \InvalidArgumentException($bOLOrderArrayErrorMessage, __LINE__);
        }
        if (is_null($bOLOrder) || (is_array($bOLOrder) && empty($bOLOrder))) {
            unset($this->BOLOrder);
        } else {
            $this->BOLOrder = $bOLOrder;
        }
        return $this;
    }
    /**
     * Add item to BOLOrder value
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexBOLOrder $item
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBOLOrder
     */
    public function addToBOLOrder(\Speedex\SpeedexStruct\SpeedexBOLOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Speedex\SpeedexStruct\SpeedexBOLOrder) {
            throw new \InvalidArgumentException(sprintf('The BOLOrder property can only contain items of type \Speedex\SpeedexStruct\SpeedexBOLOrder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BOLOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Speedex\SpeedexStruct\SpeedexBOLOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Speedex\SpeedexStruct\SpeedexBOLOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Speedex\SpeedexStruct\SpeedexBOLOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Speedex\SpeedexStruct\SpeedexBOLOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Speedex\SpeedexStruct\SpeedexBOLOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BOLOrder
     */
    public function getAttributeName()
    {
        return 'BOLOrder';
    }
}
