<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsignmentCollectOnDelivery SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexConsignmentCollectOnDelivery extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The ConsignmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNumber;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * Constructor method for ConsignmentCollectOnDelivery
     * @uses SpeedexConsignmentCollectOnDelivery::setAmount()
     * @uses SpeedexConsignmentCollectOnDelivery::setConsignmentNumber()
     * @uses SpeedexConsignmentCollectOnDelivery::setDate()
     * @param float $amount
     * @param string $consignmentNumber
     * @param string $date
     */
    public function __construct($amount = null, $consignmentNumber = null, $date = null)
    {
        $this
            ->setAmount($amount)
            ->setConsignmentNumber($consignmentNumber)
            ->setDate($date);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Speedex\SpeedexStruct\SpeedexConsignmentCollectOnDelivery
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ConsignmentNumber value
     * @return string|null
     */
    public function getConsignmentNumber()
    {
        return $this->ConsignmentNumber;
    }
    /**
     * Set ConsignmentNumber value
     * @param string $consignmentNumber
     * @return \Speedex\SpeedexStruct\SpeedexConsignmentCollectOnDelivery
     */
    public function setConsignmentNumber($consignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNumber) && !is_string($consignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNumber, true), gettype($consignmentNumber)), __LINE__);
        }
        $this->ConsignmentNumber = $consignmentNumber;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Speedex\SpeedexStruct\SpeedexConsignmentCollectOnDelivery
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
}
