<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Checkpoint SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCheckpoint extends AbstractStructBase
{
    /**
     * The CheckpointDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CheckpointDate;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Branch;
    /**
     * The BranchID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchID;
    /**
     * The ClientComments1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientComments1;
    /**
     * The ClientRef1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientRef1;
    /**
     * The ClientRef2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientRef2;
    /**
     * The ClientRef3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientRef3;
    /**
     * The SpeedexComments1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpeedexComments1;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDesc;
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherID;
    /**
     * Constructor method for Checkpoint
     * @uses SpeedexCheckpoint::setCheckpointDate()
     * @uses SpeedexCheckpoint::setBranch()
     * @uses SpeedexCheckpoint::setBranchID()
     * @uses SpeedexCheckpoint::setClientComments1()
     * @uses SpeedexCheckpoint::setClientRef1()
     * @uses SpeedexCheckpoint::setClientRef2()
     * @uses SpeedexCheckpoint::setClientRef3()
     * @uses SpeedexCheckpoint::setSpeedexComments1()
     * @uses SpeedexCheckpoint::setStatusCode()
     * @uses SpeedexCheckpoint::setStatusDesc()
     * @uses SpeedexCheckpoint::setVoucherID()
     * @param string $checkpointDate
     * @param string $branch
     * @param string $branchID
     * @param string $clientComments1
     * @param string $clientRef1
     * @param string $clientRef2
     * @param string $clientRef3
     * @param string $speedexComments1
     * @param string $statusCode
     * @param string $statusDesc
     * @param string $voucherID
     */
    public function __construct($checkpointDate = null, $branch = null, $branchID = null, $clientComments1 = null, $clientRef1 = null, $clientRef2 = null, $clientRef3 = null, $speedexComments1 = null, $statusCode = null, $statusDesc = null, $voucherID = null)
    {
        $this
            ->setCheckpointDate($checkpointDate)
            ->setBranch($branch)
            ->setBranchID($branchID)
            ->setClientComments1($clientComments1)
            ->setClientRef1($clientRef1)
            ->setClientRef2($clientRef2)
            ->setClientRef3($clientRef3)
            ->setSpeedexComments1($speedexComments1)
            ->setStatusCode($statusCode)
            ->setStatusDesc($statusDesc)
            ->setVoucherID($voucherID);
    }
    /**
     * Get CheckpointDate value
     * @return string
     */
    public function getCheckpointDate()
    {
        return $this->CheckpointDate;
    }
    /**
     * Set CheckpointDate value
     * @param string $checkpointDate
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setCheckpointDate($checkpointDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkpointDate) && !is_string($checkpointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkpointDate, true), gettype($checkpointDate)), __LINE__);
        }
        $this->CheckpointDate = $checkpointDate;
        return $this;
    }
    /**
     * Get Branch value
     * @return string|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param string $branch
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setBranch($branch = null)
    {
        // validation for constraint: string
        if (!is_null($branch) && !is_string($branch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branch, true), gettype($branch)), __LINE__);
        }
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get BranchID value
     * @return string|null
     */
    public function getBranchID()
    {
        return $this->BranchID;
    }
    /**
     * Set BranchID value
     * @param string $branchID
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setBranchID($branchID = null)
    {
        // validation for constraint: string
        if (!is_null($branchID) && !is_string($branchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchID, true), gettype($branchID)), __LINE__);
        }
        $this->BranchID = $branchID;
        return $this;
    }
    /**
     * Get ClientComments1 value
     * @return string|null
     */
    public function getClientComments1()
    {
        return $this->ClientComments1;
    }
    /**
     * Set ClientComments1 value
     * @param string $clientComments1
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setClientComments1($clientComments1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientComments1) && !is_string($clientComments1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientComments1, true), gettype($clientComments1)), __LINE__);
        }
        $this->ClientComments1 = $clientComments1;
        return $this;
    }
    /**
     * Get ClientRef1 value
     * @return string|null
     */
    public function getClientRef1()
    {
        return $this->ClientRef1;
    }
    /**
     * Set ClientRef1 value
     * @param string $clientRef1
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setClientRef1($clientRef1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef1) && !is_string($clientRef1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef1, true), gettype($clientRef1)), __LINE__);
        }
        $this->ClientRef1 = $clientRef1;
        return $this;
    }
    /**
     * Get ClientRef2 value
     * @return string|null
     */
    public function getClientRef2()
    {
        return $this->ClientRef2;
    }
    /**
     * Set ClientRef2 value
     * @param string $clientRef2
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setClientRef2($clientRef2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef2) && !is_string($clientRef2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef2, true), gettype($clientRef2)), __LINE__);
        }
        $this->ClientRef2 = $clientRef2;
        return $this;
    }
    /**
     * Get ClientRef3 value
     * @return string|null
     */
    public function getClientRef3()
    {
        return $this->ClientRef3;
    }
    /**
     * Set ClientRef3 value
     * @param string $clientRef3
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setClientRef3($clientRef3 = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef3) && !is_string($clientRef3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef3, true), gettype($clientRef3)), __LINE__);
        }
        $this->ClientRef3 = $clientRef3;
        return $this;
    }
    /**
     * Get SpeedexComments1 value
     * @return string|null
     */
    public function getSpeedexComments1()
    {
        return $this->SpeedexComments1;
    }
    /**
     * Set SpeedexComments1 value
     * @param string $speedexComments1
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setSpeedexComments1($speedexComments1 = null)
    {
        // validation for constraint: string
        if (!is_null($speedexComments1) && !is_string($speedexComments1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speedexComments1, true), gettype($speedexComments1)), __LINE__);
        }
        $this->SpeedexComments1 = $speedexComments1;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusDesc value
     * @return string|null
     */
    public function getStatusDesc()
    {
        return $this->StatusDesc;
    }
    /**
     * Set StatusDesc value
     * @param string $statusDesc
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setStatusDesc($statusDesc = null)
    {
        // validation for constraint: string
        if (!is_null($statusDesc) && !is_string($statusDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDesc, true), gettype($statusDesc)), __LINE__);
        }
        $this->StatusDesc = $statusDesc;
        return $this;
    }
    /**
     * Get VoucherID value
     * @return string|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param string $voucherID
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: string
        if (!is_null($voucherID) && !is_string($voucherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
}
