<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherPOD SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetVoucherPOD extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The voucherIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfString
     */
    public $voucherIDs;
    /**
     * Constructor method for GetVoucherPOD
     * @uses SpeedexGetVoucherPOD::setSessionID()
     * @uses SpeedexGetVoucherPOD::setVoucherIDs()
     * @param string $sessionID
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs
     */
    public function __construct($sessionID = null, \Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setVoucherIDs($voucherIDs);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherPOD
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get voucherIDs value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfString|null
     */
    public function getVoucherIDs()
    {
        return $this->voucherIDs;
    }
    /**
     * Set voucherIDs value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherPOD
     */
    public function setVoucherIDs(\Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs = null)
    {
        $this->voucherIDs = $voucherIDs;
        return $this;
    }
}
