<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consignment SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexConsignment extends AbstractStructBase
{
    /**
     * The BenchWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BenchWeight;
    /**
     * The CollectOnDeliveryCashAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CollectOnDeliveryCashAmount;
    /**
     * The CollectOnDeliveryCheckAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CollectOnDeliveryCheckAmount;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The IsReturn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReturn;
    /**
     * The IsSaturdayDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSaturdayDelivery;
    /**
     * The TotalNumberOfParcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalNumberOfParcels;
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge;
    /**
     * The CustomerAgreementCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAgreementCode;
    /**
     * The CustomerCostCenterCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCostCenterCode;
    /**
     * The CustomerReference1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference1;
    /**
     * The CustomerReference2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference2;
    /**
     * The CustomerReference3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference3;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The DeliveryCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryCity;
    /**
     * The DeliveryCountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryCountryCode;
    /**
     * The DeliveryCustomerComments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryCustomerComments;
    /**
     * The DeliveryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryName;
    /**
     * The DeliveryPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPhoneNumber;
    /**
     * The DeliveryPostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPostCode;
    /**
     * The DeliveryTimeFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTimeFrom;
    /**
     * The DeliveryTimeTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTimeTo;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventCode;
    /**
     * The EventGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventGroupCode;
    /**
     * The MasterConsignmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterConsignmentNumber;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The PickupAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupAddress;
    /**
     * The PickupCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupCity;
    /**
     * The PickupCountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupCountryCode;
    /**
     * The PickupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupName;
    /**
     * The PickupPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupPhoneNumber;
    /**
     * The PickupPostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupPostCode;
    /**
     * Constructor method for Consignment
     * @uses SpeedexConsignment::setBenchWeight()
     * @uses SpeedexConsignment::setCollectOnDeliveryCashAmount()
     * @uses SpeedexConsignment::setCollectOnDeliveryCheckAmount()
     * @uses SpeedexConsignment::setInsuranceAmount()
     * @uses SpeedexConsignment::setIsReturn()
     * @uses SpeedexConsignment::setIsSaturdayDelivery()
     * @uses SpeedexConsignment::setTotalNumberOfParcels()
     * @uses SpeedexConsignment::setCharge()
     * @uses SpeedexConsignment::setCustomerAgreementCode()
     * @uses SpeedexConsignment::setCustomerCostCenterCode()
     * @uses SpeedexConsignment::setCustomerReference1()
     * @uses SpeedexConsignment::setCustomerReference2()
     * @uses SpeedexConsignment::setCustomerReference3()
     * @uses SpeedexConsignment::setDeliveryAddress()
     * @uses SpeedexConsignment::setDeliveryCity()
     * @uses SpeedexConsignment::setDeliveryCountryCode()
     * @uses SpeedexConsignment::setDeliveryCustomerComments()
     * @uses SpeedexConsignment::setDeliveryName()
     * @uses SpeedexConsignment::setDeliveryPhoneNumber()
     * @uses SpeedexConsignment::setDeliveryPostCode()
     * @uses SpeedexConsignment::setDeliveryTimeFrom()
     * @uses SpeedexConsignment::setDeliveryTimeTo()
     * @uses SpeedexConsignment::setEventCode()
     * @uses SpeedexConsignment::setEventGroupCode()
     * @uses SpeedexConsignment::setMasterConsignmentNumber()
     * @uses SpeedexConsignment::setNumber()
     * @uses SpeedexConsignment::setPickupAddress()
     * @uses SpeedexConsignment::setPickupCity()
     * @uses SpeedexConsignment::setPickupCountryCode()
     * @uses SpeedexConsignment::setPickupName()
     * @uses SpeedexConsignment::setPickupPhoneNumber()
     * @uses SpeedexConsignment::setPickupPostCode()
     * @param float $benchWeight
     * @param float $collectOnDeliveryCashAmount
     * @param float $collectOnDeliveryCheckAmount
     * @param float $insuranceAmount
     * @param bool $isReturn
     * @param bool $isSaturdayDelivery
     * @param int $totalNumberOfParcels
     * @param string $charge
     * @param string $customerAgreementCode
     * @param string $customerCostCenterCode
     * @param string $customerReference1
     * @param string $customerReference2
     * @param string $customerReference3
     * @param string $deliveryAddress
     * @param string $deliveryCity
     * @param string $deliveryCountryCode
     * @param string $deliveryCustomerComments
     * @param string $deliveryName
     * @param string $deliveryPhoneNumber
     * @param string $deliveryPostCode
     * @param string $deliveryTimeFrom
     * @param string $deliveryTimeTo
     * @param string $eventCode
     * @param string $eventGroupCode
     * @param string $masterConsignmentNumber
     * @param string $number
     * @param string $pickupAddress
     * @param string $pickupCity
     * @param string $pickupCountryCode
     * @param string $pickupName
     * @param string $pickupPhoneNumber
     * @param string $pickupPostCode
     */
    public function __construct($benchWeight = null, $collectOnDeliveryCashAmount = null, $collectOnDeliveryCheckAmount = null, $insuranceAmount = null, $isReturn = null, $isSaturdayDelivery = null, $totalNumberOfParcels = null, $charge = null, $customerAgreementCode = null, $customerCostCenterCode = null, $customerReference1 = null, $customerReference2 = null, $customerReference3 = null, $deliveryAddress = null, $deliveryCity = null, $deliveryCountryCode = null, $deliveryCustomerComments = null, $deliveryName = null, $deliveryPhoneNumber = null, $deliveryPostCode = null, $deliveryTimeFrom = null, $deliveryTimeTo = null, $eventCode = null, $eventGroupCode = null, $masterConsignmentNumber = null, $number = null, $pickupAddress = null, $pickupCity = null, $pickupCountryCode = null, $pickupName = null, $pickupPhoneNumber = null, $pickupPostCode = null)
    {
        $this
            ->setBenchWeight($benchWeight)
            ->setCollectOnDeliveryCashAmount($collectOnDeliveryCashAmount)
            ->setCollectOnDeliveryCheckAmount($collectOnDeliveryCheckAmount)
            ->setInsuranceAmount($insuranceAmount)
            ->setIsReturn($isReturn)
            ->setIsSaturdayDelivery($isSaturdayDelivery)
            ->setTotalNumberOfParcels($totalNumberOfParcels)
            ->setCharge($charge)
            ->setCustomerAgreementCode($customerAgreementCode)
            ->setCustomerCostCenterCode($customerCostCenterCode)
            ->setCustomerReference1($customerReference1)
            ->setCustomerReference2($customerReference2)
            ->setCustomerReference3($customerReference3)
            ->setDeliveryAddress($deliveryAddress)
            ->setDeliveryCity($deliveryCity)
            ->setDeliveryCountryCode($deliveryCountryCode)
            ->setDeliveryCustomerComments($deliveryCustomerComments)
            ->setDeliveryName($deliveryName)
            ->setDeliveryPhoneNumber($deliveryPhoneNumber)
            ->setDeliveryPostCode($deliveryPostCode)
            ->setDeliveryTimeFrom($deliveryTimeFrom)
            ->setDeliveryTimeTo($deliveryTimeTo)
            ->setEventCode($eventCode)
            ->setEventGroupCode($eventGroupCode)
            ->setMasterConsignmentNumber($masterConsignmentNumber)
            ->setNumber($number)
            ->setPickupAddress($pickupAddress)
            ->setPickupCity($pickupCity)
            ->setPickupCountryCode($pickupCountryCode)
            ->setPickupName($pickupName)
            ->setPickupPhoneNumber($pickupPhoneNumber)
            ->setPickupPostCode($pickupPostCode);
    }
    /**
     * Get BenchWeight value
     * @return float
     */
    public function getBenchWeight()
    {
        return $this->BenchWeight;
    }
    /**
     * Set BenchWeight value
     * @param float $benchWeight
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setBenchWeight($benchWeight = null)
    {
        // validation for constraint: float
        if (!is_null($benchWeight) && !(is_float($benchWeight) || is_numeric($benchWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($benchWeight, true), gettype($benchWeight)), __LINE__);
        }
        $this->BenchWeight = $benchWeight;
        return $this;
    }
    /**
     * Get CollectOnDeliveryCashAmount value
     * @return float
     */
    public function getCollectOnDeliveryCashAmount()
    {
        return $this->CollectOnDeliveryCashAmount;
    }
    /**
     * Set CollectOnDeliveryCashAmount value
     * @param float $collectOnDeliveryCashAmount
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCollectOnDeliveryCashAmount($collectOnDeliveryCashAmount = null)
    {
        // validation for constraint: float
        if (!is_null($collectOnDeliveryCashAmount) && !(is_float($collectOnDeliveryCashAmount) || is_numeric($collectOnDeliveryCashAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($collectOnDeliveryCashAmount, true), gettype($collectOnDeliveryCashAmount)), __LINE__);
        }
        $this->CollectOnDeliveryCashAmount = $collectOnDeliveryCashAmount;
        return $this;
    }
    /**
     * Get CollectOnDeliveryCheckAmount value
     * @return float
     */
    public function getCollectOnDeliveryCheckAmount()
    {
        return $this->CollectOnDeliveryCheckAmount;
    }
    /**
     * Set CollectOnDeliveryCheckAmount value
     * @param float $collectOnDeliveryCheckAmount
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCollectOnDeliveryCheckAmount($collectOnDeliveryCheckAmount = null)
    {
        // validation for constraint: float
        if (!is_null($collectOnDeliveryCheckAmount) && !(is_float($collectOnDeliveryCheckAmount) || is_numeric($collectOnDeliveryCheckAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($collectOnDeliveryCheckAmount, true), gettype($collectOnDeliveryCheckAmount)), __LINE__);
        }
        $this->CollectOnDeliveryCheckAmount = $collectOnDeliveryCheckAmount;
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get IsReturn value
     * @return bool
     */
    public function getIsReturn()
    {
        return $this->IsReturn;
    }
    /**
     * Set IsReturn value
     * @param bool $isReturn
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setIsReturn($isReturn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturn) && !is_bool($isReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturn, true), gettype($isReturn)), __LINE__);
        }
        $this->IsReturn = $isReturn;
        return $this;
    }
    /**
     * Get IsSaturdayDelivery value
     * @return bool
     */
    public function getIsSaturdayDelivery()
    {
        return $this->IsSaturdayDelivery;
    }
    /**
     * Set IsSaturdayDelivery value
     * @param bool $isSaturdayDelivery
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setIsSaturdayDelivery($isSaturdayDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSaturdayDelivery) && !is_bool($isSaturdayDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSaturdayDelivery, true), gettype($isSaturdayDelivery)), __LINE__);
        }
        $this->IsSaturdayDelivery = $isSaturdayDelivery;
        return $this;
    }
    /**
     * Get TotalNumberOfParcels value
     * @return int
     */
    public function getTotalNumberOfParcels()
    {
        return $this->TotalNumberOfParcels;
    }
    /**
     * Set TotalNumberOfParcels value
     * @param int $totalNumberOfParcels
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setTotalNumberOfParcels($totalNumberOfParcels = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfParcels) && !(is_int($totalNumberOfParcels) || ctype_digit($totalNumberOfParcels))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfParcels, true), gettype($totalNumberOfParcels)), __LINE__);
        }
        $this->TotalNumberOfParcels = $totalNumberOfParcels;
        return $this;
    }
    /**
     * Get Charge value
     * @return string|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param string $charge
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCharge($charge = null)
    {
        // validation for constraint: string
        if (!is_null($charge) && !is_string($charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge, true), gettype($charge)), __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get CustomerAgreementCode value
     * @return string|null
     */
    public function getCustomerAgreementCode()
    {
        return $this->CustomerAgreementCode;
    }
    /**
     * Set CustomerAgreementCode value
     * @param string $customerAgreementCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCustomerAgreementCode($customerAgreementCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerAgreementCode) && !is_string($customerAgreementCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAgreementCode, true), gettype($customerAgreementCode)), __LINE__);
        }
        $this->CustomerAgreementCode = $customerAgreementCode;
        return $this;
    }
    /**
     * Get CustomerCostCenterCode value
     * @return string|null
     */
    public function getCustomerCostCenterCode()
    {
        return $this->CustomerCostCenterCode;
    }
    /**
     * Set CustomerCostCenterCode value
     * @param string $customerCostCenterCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCustomerCostCenterCode($customerCostCenterCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCostCenterCode) && !is_string($customerCostCenterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCostCenterCode, true), gettype($customerCostCenterCode)), __LINE__);
        }
        $this->CustomerCostCenterCode = $customerCostCenterCode;
        return $this;
    }
    /**
     * Get CustomerReference1 value
     * @return string|null
     */
    public function getCustomerReference1()
    {
        return $this->CustomerReference1;
    }
    /**
     * Set CustomerReference1 value
     * @param string $customerReference1
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCustomerReference1($customerReference1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference1) && !is_string($customerReference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference1, true), gettype($customerReference1)), __LINE__);
        }
        $this->CustomerReference1 = $customerReference1;
        return $this;
    }
    /**
     * Get CustomerReference2 value
     * @return string|null
     */
    public function getCustomerReference2()
    {
        return $this->CustomerReference2;
    }
    /**
     * Set CustomerReference2 value
     * @param string $customerReference2
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCustomerReference2($customerReference2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference2) && !is_string($customerReference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference2, true), gettype($customerReference2)), __LINE__);
        }
        $this->CustomerReference2 = $customerReference2;
        return $this;
    }
    /**
     * Get CustomerReference3 value
     * @return string|null
     */
    public function getCustomerReference3()
    {
        return $this->CustomerReference3;
    }
    /**
     * Set CustomerReference3 value
     * @param string $customerReference3
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setCustomerReference3($customerReference3 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference3) && !is_string($customerReference3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference3, true), gettype($customerReference3)), __LINE__);
        }
        $this->CustomerReference3 = $customerReference3;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param string $deliveryAddress
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get DeliveryCity value
     * @return string|null
     */
    public function getDeliveryCity()
    {
        return $this->DeliveryCity;
    }
    /**
     * Set DeliveryCity value
     * @param string $deliveryCity
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryCity($deliveryCity = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCity) && !is_string($deliveryCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCity, true), gettype($deliveryCity)), __LINE__);
        }
        $this->DeliveryCity = $deliveryCity;
        return $this;
    }
    /**
     * Get DeliveryCountryCode value
     * @return string|null
     */
    public function getDeliveryCountryCode()
    {
        return $this->DeliveryCountryCode;
    }
    /**
     * Set DeliveryCountryCode value
     * @param string $deliveryCountryCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryCountryCode($deliveryCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCountryCode) && !is_string($deliveryCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCountryCode, true), gettype($deliveryCountryCode)), __LINE__);
        }
        $this->DeliveryCountryCode = $deliveryCountryCode;
        return $this;
    }
    /**
     * Get DeliveryCustomerComments value
     * @return string|null
     */
    public function getDeliveryCustomerComments()
    {
        return $this->DeliveryCustomerComments;
    }
    /**
     * Set DeliveryCustomerComments value
     * @param string $deliveryCustomerComments
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryCustomerComments($deliveryCustomerComments = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCustomerComments) && !is_string($deliveryCustomerComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCustomerComments, true), gettype($deliveryCustomerComments)), __LINE__);
        }
        $this->DeliveryCustomerComments = $deliveryCustomerComments;
        return $this;
    }
    /**
     * Get DeliveryName value
     * @return string|null
     */
    public function getDeliveryName()
    {
        return $this->DeliveryName;
    }
    /**
     * Set DeliveryName value
     * @param string $deliveryName
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryName($deliveryName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryName) && !is_string($deliveryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryName, true), gettype($deliveryName)), __LINE__);
        }
        $this->DeliveryName = $deliveryName;
        return $this;
    }
    /**
     * Get DeliveryPhoneNumber value
     * @return string|null
     */
    public function getDeliveryPhoneNumber()
    {
        return $this->DeliveryPhoneNumber;
    }
    /**
     * Set DeliveryPhoneNumber value
     * @param string $deliveryPhoneNumber
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryPhoneNumber($deliveryPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPhoneNumber) && !is_string($deliveryPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPhoneNumber, true), gettype($deliveryPhoneNumber)), __LINE__);
        }
        $this->DeliveryPhoneNumber = $deliveryPhoneNumber;
        return $this;
    }
    /**
     * Get DeliveryPostCode value
     * @return string|null
     */
    public function getDeliveryPostCode()
    {
        return $this->DeliveryPostCode;
    }
    /**
     * Set DeliveryPostCode value
     * @param string $deliveryPostCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryPostCode($deliveryPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPostCode) && !is_string($deliveryPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPostCode, true), gettype($deliveryPostCode)), __LINE__);
        }
        $this->DeliveryPostCode = $deliveryPostCode;
        return $this;
    }
    /**
     * Get DeliveryTimeFrom value
     * @return string|null
     */
    public function getDeliveryTimeFrom()
    {
        return $this->DeliveryTimeFrom;
    }
    /**
     * Set DeliveryTimeFrom value
     * @param string $deliveryTimeFrom
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryTimeFrom($deliveryTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeFrom) && !is_string($deliveryTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimeFrom, true), gettype($deliveryTimeFrom)), __LINE__);
        }
        $this->DeliveryTimeFrom = $deliveryTimeFrom;
        return $this;
    }
    /**
     * Get DeliveryTimeTo value
     * @return string|null
     */
    public function getDeliveryTimeTo()
    {
        return $this->DeliveryTimeTo;
    }
    /**
     * Set DeliveryTimeTo value
     * @param string $deliveryTimeTo
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setDeliveryTimeTo($deliveryTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeTo) && !is_string($deliveryTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimeTo, true), gettype($deliveryTimeTo)), __LINE__);
        }
        $this->DeliveryTimeTo = $deliveryTimeTo;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventGroupCode value
     * @return string|null
     */
    public function getEventGroupCode()
    {
        return $this->EventGroupCode;
    }
    /**
     * Set EventGroupCode value
     * @param string $eventGroupCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setEventGroupCode($eventGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventGroupCode) && !is_string($eventGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGroupCode, true), gettype($eventGroupCode)), __LINE__);
        }
        $this->EventGroupCode = $eventGroupCode;
        return $this;
    }
    /**
     * Get MasterConsignmentNumber value
     * @return string|null
     */
    public function getMasterConsignmentNumber()
    {
        return $this->MasterConsignmentNumber;
    }
    /**
     * Set MasterConsignmentNumber value
     * @param string $masterConsignmentNumber
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setMasterConsignmentNumber($masterConsignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($masterConsignmentNumber) && !is_string($masterConsignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterConsignmentNumber, true), gettype($masterConsignmentNumber)), __LINE__);
        }
        $this->MasterConsignmentNumber = $masterConsignmentNumber;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return string|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param string $pickupAddress
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setPickupAddress($pickupAddress = null)
    {
        // validation for constraint: string
        if (!is_null($pickupAddress) && !is_string($pickupAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupAddress, true), gettype($pickupAddress)), __LINE__);
        }
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get PickupCity value
     * @return string|null
     */
    public function getPickupCity()
    {
        return $this->PickupCity;
    }
    /**
     * Set PickupCity value
     * @param string $pickupCity
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setPickupCity($pickupCity = null)
    {
        // validation for constraint: string
        if (!is_null($pickupCity) && !is_string($pickupCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupCity, true), gettype($pickupCity)), __LINE__);
        }
        $this->PickupCity = $pickupCity;
        return $this;
    }
    /**
     * Get PickupCountryCode value
     * @return string|null
     */
    public function getPickupCountryCode()
    {
        return $this->PickupCountryCode;
    }
    /**
     * Set PickupCountryCode value
     * @param string $pickupCountryCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setPickupCountryCode($pickupCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickupCountryCode) && !is_string($pickupCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupCountryCode, true), gettype($pickupCountryCode)), __LINE__);
        }
        $this->PickupCountryCode = $pickupCountryCode;
        return $this;
    }
    /**
     * Get PickupName value
     * @return string|null
     */
    public function getPickupName()
    {
        return $this->PickupName;
    }
    /**
     * Set PickupName value
     * @param string $pickupName
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setPickupName($pickupName = null)
    {
        // validation for constraint: string
        if (!is_null($pickupName) && !is_string($pickupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupName, true), gettype($pickupName)), __LINE__);
        }
        $this->PickupName = $pickupName;
        return $this;
    }
    /**
     * Get PickupPhoneNumber value
     * @return string|null
     */
    public function getPickupPhoneNumber()
    {
        return $this->PickupPhoneNumber;
    }
    /**
     * Set PickupPhoneNumber value
     * @param string $pickupPhoneNumber
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setPickupPhoneNumber($pickupPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pickupPhoneNumber) && !is_string($pickupPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupPhoneNumber, true), gettype($pickupPhoneNumber)), __LINE__);
        }
        $this->PickupPhoneNumber = $pickupPhoneNumber;
        return $this;
    }
    /**
     * Get PickupPostCode value
     * @return string|null
     */
    public function getPickupPostCode()
    {
        return $this->PickupPostCode;
    }
    /**
     * Set PickupPostCode value
     * @param string $pickupPostCode
     * @return \Speedex\SpeedexStruct\SpeedexConsignment
     */
    public function setPickupPostCode($pickupPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickupPostCode) && !is_string($pickupPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupPostCode, true), gettype($pickupPostCode)), __LINE__);
        }
        $this->PickupPostCode = $pickupPostCode;
        return $this;
    }
}
