<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBOLPdf SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetBOLPdf extends AbstractStructBase
{
    /**
     * The perVoucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $perVoucher;
    /**
     * The paperType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paperType;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The voucherIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfString
     */
    public $voucherIDs;
    /**
     * Constructor method for GetBOLPdf
     * @uses SpeedexGetBOLPdf::setPerVoucher()
     * @uses SpeedexGetBOLPdf::setPaperType()
     * @uses SpeedexGetBOLPdf::setSessionID()
     * @uses SpeedexGetBOLPdf::setVoucherIDs()
     * @param bool $perVoucher
     * @param int $paperType
     * @param string $sessionID
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs
     */
    public function __construct($perVoucher = null, $paperType = null, $sessionID = null, \Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs = null)
    {
        $this
            ->setPerVoucher($perVoucher)
            ->setPaperType($paperType)
            ->setSessionID($sessionID)
            ->setVoucherIDs($voucherIDs);
    }
    /**
     * Get perVoucher value
     * @return bool
     */
    public function getPerVoucher()
    {
        return $this->perVoucher;
    }
    /**
     * Set perVoucher value
     * @param bool $perVoucher
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLPdf
     */
    public function setPerVoucher($perVoucher = null)
    {
        // validation for constraint: boolean
        if (!is_null($perVoucher) && !is_bool($perVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($perVoucher, true), gettype($perVoucher)), __LINE__);
        }
        $this->perVoucher = $perVoucher;
        return $this;
    }
    /**
     * Get paperType value
     * @return int
     */
    public function getPaperType()
    {
        return $this->paperType;
    }
    /**
     * Set paperType value
     * @param int $paperType
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLPdf
     */
    public function setPaperType($paperType = null)
    {
        // validation for constraint: int
        if (!is_null($paperType) && !(is_int($paperType) || ctype_digit($paperType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paperType, true), gettype($paperType)), __LINE__);
        }
        $this->paperType = $paperType;
        return $this;
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLPdf
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get voucherIDs value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfString|null
     */
    public function getVoucherIDs()
    {
        return $this->voucherIDs;
    }
    /**
     * Set voucherIDs value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs
     * @return \Speedex\SpeedexStruct\SpeedexGetBOLPdf
     */
    public function setVoucherIDs(\Speedex\SpeedexArray\SpeedexArrayOfString $voucherIDs = null)
    {
        $this->voucherIDs = $voucherIDs;
        return $this;
    }
}
