<?php

namespace Speedex\SpeedexService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reschedule SpeedexService
 * @package Speedex
 * @subpackage Services
 */
class SpeedexReschedule extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReschedulePickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexReschedulePickup $parameters
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickupResponse|bool
     */
    public function ReschedulePickup(\Speedex\SpeedexStruct\SpeedexReschedulePickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReschedulePickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Speedex\SpeedexStruct\SpeedexReschedulePickupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
