<?php

namespace Speedex\SpeedexService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create SpeedexService
 * @package Speedex
 * @subpackage Services
 */
class SpeedexCreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateBOL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateBOL $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOLResponse|bool
     */
    public function CreateBOL(\Speedex\SpeedexStruct\SpeedexCreateBOL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBOL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBOLwithOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateBOLwithOrder $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOLwithOrderResponse|bool
     */
    public function CreateBOLwithOrder(\Speedex\SpeedexStruct\SpeedexCreateBOLwithOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBOLwithOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreateSession $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreateSessionResponse|bool
     */
    public function CreateSession(\Speedex\SpeedexStruct\SpeedexCreateSession $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexCreatePickup $parameters
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickupResponse|bool
     */
    public function CreatePickup(\Speedex\SpeedexStruct\SpeedexCreatePickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOLResponse|\Speedex\SpeedexStruct\SpeedexCreateBOLwithOrderResponse|\Speedex\SpeedexStruct\SpeedexCreatePickupResponse|\Speedex\SpeedexStruct\SpeedexCreateSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
