<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBOL SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCreateBOL extends AbstractStructBase
{
    /**
     * The tableFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $tableFlag;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The inListPod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfBOL
     */
    public $inListPod;
    /**
     * Constructor method for CreateBOL
     * @uses SpeedexCreateBOL::setTableFlag()
     * @uses SpeedexCreateBOL::setSessionID()
     * @uses SpeedexCreateBOL::setInListPod()
     * @param int $tableFlag
     * @param string $sessionID
     * @param \Speedex\SpeedexArray\SpeedexArrayOfBOL $inListPod
     */
    public function __construct($tableFlag = null, $sessionID = null, \Speedex\SpeedexArray\SpeedexArrayOfBOL $inListPod = null)
    {
        $this
            ->setTableFlag($tableFlag)
            ->setSessionID($sessionID)
            ->setInListPod($inListPod);
    }
    /**
     * Get tableFlag value
     * @return int
     */
    public function getTableFlag()
    {
        return $this->tableFlag;
    }
    /**
     * Set tableFlag value
     * @param int $tableFlag
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOL
     */
    public function setTableFlag($tableFlag = null)
    {
        // validation for constraint: int
        if (!is_null($tableFlag) && !(is_int($tableFlag) || ctype_digit($tableFlag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tableFlag, true), gettype($tableFlag)), __LINE__);
        }
        $this->tableFlag = $tableFlag;
        return $this;
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOL
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get inListPod value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBOL|null
     */
    public function getInListPod()
    {
        return $this->inListPod;
    }
    /**
     * Set inListPod value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfBOL $inListPod
     * @return \Speedex\SpeedexStruct\SpeedexCreateBOL
     */
    public function setInListPod(\Speedex\SpeedexArray\SpeedexArrayOfBOL $inListPod = null)
    {
        $this->inListPod = $inListPod;
        return $this;
    }
}
