<?php

namespace Speedex\SpeedexService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Destroy SpeedexService
 * @package Speedex
 * @subpackage Services
 */
class SpeedexDestroy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DestroySession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Speedex\SpeedexStruct\SpeedexDestroySession $parameters
     * @return \Speedex\SpeedexStruct\SpeedexDestroySessionResponse|bool
     */
    public function DestroySession(\Speedex\SpeedexStruct\SpeedexDestroySession $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DestroySession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Speedex\SpeedexStruct\SpeedexDestroySessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
