<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConsignmentsByDateResult SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetConsignmentsByDateResult extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfConsignment
     */
    public $Result;
    /**
     * Constructor method for GetConsignmentsByDateResult
     * @uses SpeedexGetConsignmentsByDateResult::setStatusCode()
     * @uses SpeedexGetConsignmentsByDateResult::setMessage()
     * @uses SpeedexGetConsignmentsByDateResult::setResult()
     * @param int $statusCode
     * @param string $message
     * @param \Speedex\SpeedexArray\SpeedexArrayOfConsignment $result
     */
    public function __construct($statusCode = null, $message = null, \Speedex\SpeedexArray\SpeedexArrayOfConsignment $result = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setMessage($message)
            ->setResult($result);
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Speedex\SpeedexStruct\SpeedexGetConsignmentsByDateResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Speedex\SpeedexStruct\SpeedexGetConsignmentsByDateResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Result value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfConsignment|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfConsignment $result
     * @return \Speedex\SpeedexStruct\SpeedexGetConsignmentsByDateResult
     */
    public function setResult(\Speedex\SpeedexArray\SpeedexArrayOfConsignment $result = null)
    {
        $this->Result = $result;
        return $this;
    }
}
