<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherCod SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexVoucherCod extends AbstractStructBase
{
    /**
     * The CashValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CashValue;
    /**
     * The ChequeValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ChequeValue;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DepositDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DepositDate;
    /**
     * The isReturned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $isReturned;
    /**
     * The MoneyCollected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MoneyCollected;
    /**
     * The MoneyDeposited
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MoneyDeposited;
    /**
     * The Return_Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Return_Date;
    /**
     * The ShippingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ShippingDate;
    /**
     * The ClientRef1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientRef1;
    /**
     * The ClientRef2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientRef2;
    /**
     * The ClientRef3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientRef3;
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherID;
    /**
     * Constructor method for VoucherCod
     * @uses SpeedexVoucherCod::setCashValue()
     * @uses SpeedexVoucherCod::setChequeValue()
     * @uses SpeedexVoucherCod::setDeliveryDate()
     * @uses SpeedexVoucherCod::setDepositDate()
     * @uses SpeedexVoucherCod::setIsReturned()
     * @uses SpeedexVoucherCod::setMoneyCollected()
     * @uses SpeedexVoucherCod::setMoneyDeposited()
     * @uses SpeedexVoucherCod::setReturn_Date()
     * @uses SpeedexVoucherCod::setShippingDate()
     * @uses SpeedexVoucherCod::setClientRef1()
     * @uses SpeedexVoucherCod::setClientRef2()
     * @uses SpeedexVoucherCod::setClientRef3()
     * @uses SpeedexVoucherCod::setVoucherID()
     * @param float $cashValue
     * @param float $chequeValue
     * @param string $deliveryDate
     * @param string $depositDate
     * @param int $isReturned
     * @param int $moneyCollected
     * @param int $moneyDeposited
     * @param string $return_Date
     * @param string $shippingDate
     * @param string $clientRef1
     * @param string $clientRef2
     * @param string $clientRef3
     * @param string $voucherID
     */
    public function __construct($cashValue = null, $chequeValue = null, $deliveryDate = null, $depositDate = null, $isReturned = null, $moneyCollected = null, $moneyDeposited = null, $return_Date = null, $shippingDate = null, $clientRef1 = null, $clientRef2 = null, $clientRef3 = null, $voucherID = null)
    {
        $this
            ->setCashValue($cashValue)
            ->setChequeValue($chequeValue)
            ->setDeliveryDate($deliveryDate)
            ->setDepositDate($depositDate)
            ->setIsReturned($isReturned)
            ->setMoneyCollected($moneyCollected)
            ->setMoneyDeposited($moneyDeposited)
            ->setReturn_Date($return_Date)
            ->setShippingDate($shippingDate)
            ->setClientRef1($clientRef1)
            ->setClientRef2($clientRef2)
            ->setClientRef3($clientRef3)
            ->setVoucherID($voucherID);
    }
    /**
     * Get CashValue value
     * @return float
     */
    public function getCashValue()
    {
        return $this->CashValue;
    }
    /**
     * Set CashValue value
     * @param float $cashValue
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setCashValue($cashValue = null)
    {
        // validation for constraint: float
        if (!is_null($cashValue) && !(is_float($cashValue) || is_numeric($cashValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashValue, true), gettype($cashValue)), __LINE__);
        }
        $this->CashValue = $cashValue;
        return $this;
    }
    /**
     * Get ChequeValue value
     * @return float
     */
    public function getChequeValue()
    {
        return $this->ChequeValue;
    }
    /**
     * Set ChequeValue value
     * @param float $chequeValue
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setChequeValue($chequeValue = null)
    {
        // validation for constraint: float
        if (!is_null($chequeValue) && !(is_float($chequeValue) || is_numeric($chequeValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chequeValue, true), gettype($chequeValue)), __LINE__);
        }
        $this->ChequeValue = $chequeValue;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DepositDate value
     * @return string
     */
    public function getDepositDate()
    {
        return $this->DepositDate;
    }
    /**
     * Set DepositDate value
     * @param string $depositDate
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setDepositDate($depositDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositDate) && !is_string($depositDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositDate, true), gettype($depositDate)), __LINE__);
        }
        $this->DepositDate = $depositDate;
        return $this;
    }
    /**
     * Get isReturned value
     * @return int
     */
    public function getIsReturned()
    {
        return $this->isReturned;
    }
    /**
     * Set isReturned value
     * @param int $isReturned
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: int
        if (!is_null($isReturned) && !(is_int($isReturned) || ctype_digit($isReturned))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        $this->isReturned = $isReturned;
        return $this;
    }
    /**
     * Get MoneyCollected value
     * @return int
     */
    public function getMoneyCollected()
    {
        return $this->MoneyCollected;
    }
    /**
     * Set MoneyCollected value
     * @param int $moneyCollected
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setMoneyCollected($moneyCollected = null)
    {
        // validation for constraint: int
        if (!is_null($moneyCollected) && !(is_int($moneyCollected) || ctype_digit($moneyCollected))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($moneyCollected, true), gettype($moneyCollected)), __LINE__);
        }
        $this->MoneyCollected = $moneyCollected;
        return $this;
    }
    /**
     * Get MoneyDeposited value
     * @return int
     */
    public function getMoneyDeposited()
    {
        return $this->MoneyDeposited;
    }
    /**
     * Set MoneyDeposited value
     * @param int $moneyDeposited
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setMoneyDeposited($moneyDeposited = null)
    {
        // validation for constraint: int
        if (!is_null($moneyDeposited) && !(is_int($moneyDeposited) || ctype_digit($moneyDeposited))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($moneyDeposited, true), gettype($moneyDeposited)), __LINE__);
        }
        $this->MoneyDeposited = $moneyDeposited;
        return $this;
    }
    /**
     * Get Return_Date value
     * @return string
     */
    public function getReturn_Date()
    {
        return $this->Return_Date;
    }
    /**
     * Set Return_Date value
     * @param string $return_Date
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setReturn_Date($return_Date = null)
    {
        // validation for constraint: string
        if (!is_null($return_Date) && !is_string($return_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Date, true), gettype($return_Date)), __LINE__);
        }
        $this->Return_Date = $return_Date;
        return $this;
    }
    /**
     * Get ShippingDate value
     * @return string
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }
    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
    /**
     * Get ClientRef1 value
     * @return string|null
     */
    public function getClientRef1()
    {
        return $this->ClientRef1;
    }
    /**
     * Set ClientRef1 value
     * @param string $clientRef1
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setClientRef1($clientRef1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef1) && !is_string($clientRef1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef1, true), gettype($clientRef1)), __LINE__);
        }
        $this->ClientRef1 = $clientRef1;
        return $this;
    }
    /**
     * Get ClientRef2 value
     * @return string|null
     */
    public function getClientRef2()
    {
        return $this->ClientRef2;
    }
    /**
     * Set ClientRef2 value
     * @param string $clientRef2
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setClientRef2($clientRef2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef2) && !is_string($clientRef2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef2, true), gettype($clientRef2)), __LINE__);
        }
        $this->ClientRef2 = $clientRef2;
        return $this;
    }
    /**
     * Get ClientRef3 value
     * @return string|null
     */
    public function getClientRef3()
    {
        return $this->ClientRef3;
    }
    /**
     * Set ClientRef3 value
     * @param string $clientRef3
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setClientRef3($clientRef3 = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef3) && !is_string($clientRef3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef3, true), gettype($clientRef3)), __LINE__);
        }
        $this->ClientRef3 = $clientRef3;
        return $this;
    }
    /**
     * Get VoucherID value
     * @return string|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param string $voucherID
     * @return \Speedex\SpeedexStruct\SpeedexVoucherCod
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: string
        if (!is_null($voucherID) && !is_string($voucherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
}
