<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePickup SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexCreatePickup extends AbstractStructBase
{
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The consignmentNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfString
     */
    public $consignmentNumbers;
    /**
     * Constructor method for CreatePickup
     * @uses SpeedexCreatePickup::setPickupDate()
     * @uses SpeedexCreatePickup::setPickupTimeFrom()
     * @uses SpeedexCreatePickup::setPickupTimeTo()
     * @uses SpeedexCreatePickup::setSessionID()
     * @uses SpeedexCreatePickup::setConsignmentNumbers()
     * @param string $pickupDate
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $sessionID
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers
     */
    public function __construct($pickupDate = null, $pickupTimeFrom = null, $pickupTimeTo = null, $sessionID = null, \Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers = null)
    {
        $this
            ->setPickupDate($pickupDate)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setSessionID($sessionID)
            ->setConsignmentNumbers($consignmentNumbers);
    }
    /**
     * Get pickupDate value
     * @return string
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickup
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickup
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeFrom) && !is_string($pickupTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeFrom, true), gettype($pickupTimeFrom)), __LINE__);
        }
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickup
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeTo) && !is_string($pickupTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeTo, true), gettype($pickupTimeTo)), __LINE__);
        }
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickup
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get consignmentNumbers value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfString|null
     */
    public function getConsignmentNumbers()
    {
        return $this->consignmentNumbers;
    }
    /**
     * Set consignmentNumbers value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers
     * @return \Speedex\SpeedexStruct\SpeedexCreatePickup
     */
    public function setConsignmentNumbers(\Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers = null)
    {
        $this->consignmentNumbers = $consignmentNumbers;
        return $this;
    }
}
