<?php

namespace Speedex\SpeedexArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBOL SpeedexArray
 * @package Speedex
 * @subpackage Arrays
 */
class SpeedexArrayOfBOL extends AbstractStructArrayBase
{
    /**
     * The BOL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Speedex\SpeedexStruct\SpeedexBOL[]
     */
    public $BOL;
    /**
     * Constructor method for ArrayOfBOL
     * @uses SpeedexArrayOfBOL::setBOL()
     * @param \Speedex\SpeedexStruct\SpeedexBOL[] $bOL
     */
    public function __construct(array $bOL = array())
    {
        $this
            ->setBOL($bOL);
    }
    /**
     * Get BOL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Speedex\SpeedexStruct\SpeedexBOL[]|null
     */
    public function getBOL()
    {
        return isset($this->BOL) ? $this->BOL : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBOL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBOL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBOLForArrayConstraintsFromSetBOL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBOLBOLItem) {
            // validation for constraint: itemType
            if (!$arrayOfBOLBOLItem instanceof \Speedex\SpeedexStruct\SpeedexBOL) {
                $invalidValues[] = is_object($arrayOfBOLBOLItem) ? get_class($arrayOfBOLBOLItem) : sprintf('%s(%s)', gettype($arrayOfBOLBOLItem), var_export($arrayOfBOLBOLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BOL property can only contain items of type \Speedex\SpeedexStruct\SpeedexBOL, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BOL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexBOL[] $bOL
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBOL
     */
    public function setBOL(array $bOL = array())
    {
        // validation for constraint: array
        if ('' !== ($bOLArrayErrorMessage = self::validateBOLForArrayConstraintsFromSetBOL($bOL))) {
            throw new \InvalidArgumentException($bOLArrayErrorMessage, __LINE__);
        }
        if (is_null($bOL) || (is_array($bOL) && empty($bOL))) {
            unset($this->BOL);
        } else {
            $this->BOL = $bOL;
        }
        return $this;
    }
    /**
     * Add item to BOL value
     * @throws \InvalidArgumentException
     * @param \Speedex\SpeedexStruct\SpeedexBOL $item
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBOL
     */
    public function addToBOL(\Speedex\SpeedexStruct\SpeedexBOL $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Speedex\SpeedexStruct\SpeedexBOL) {
            throw new \InvalidArgumentException(sprintf('The BOL property can only contain items of type \Speedex\SpeedexStruct\SpeedexBOL, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BOL[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Speedex\SpeedexStruct\SpeedexBOL|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Speedex\SpeedexStruct\SpeedexBOL|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Speedex\SpeedexStruct\SpeedexBOL|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Speedex\SpeedexStruct\SpeedexBOL|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Speedex\SpeedexStruct\SpeedexBOL|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BOL
     */
    public function getAttributeName()
    {
        return 'BOL';
    }
}
