<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLastCheckpointResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetLastCheckpointResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The checkpoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexStruct\SpeedexCheckpoint
     */
    public $checkpoint;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetLastCheckpointResponse
     * @uses SpeedexGetLastCheckpointResponse::setReturnCode()
     * @uses SpeedexGetLastCheckpointResponse::setCheckpoint()
     * @uses SpeedexGetLastCheckpointResponse::setReturnMessage()
     * @param int $returnCode
     * @param \Speedex\SpeedexStruct\SpeedexCheckpoint $checkpoint
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, \Speedex\SpeedexStruct\SpeedexCheckpoint $checkpoint = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setCheckpoint($checkpoint)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexGetLastCheckpointResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get checkpoint value
     * @return \Speedex\SpeedexStruct\SpeedexCheckpoint|null
     */
    public function getCheckpoint()
    {
        return $this->checkpoint;
    }
    /**
     * Set checkpoint value
     * @param \Speedex\SpeedexStruct\SpeedexCheckpoint $checkpoint
     * @return \Speedex\SpeedexStruct\SpeedexGetLastCheckpointResponse
     */
    public function setCheckpoint(\Speedex\SpeedexStruct\SpeedexCheckpoint $checkpoint = null)
    {
        $this->checkpoint = $checkpoint;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexGetLastCheckpointResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
