<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherPNG SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexVoucherPNG extends AbstractStructBase
{
    /**
     * The png
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $png;
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherID;
    /**
     * Constructor method for VoucherPNG
     * @uses SpeedexVoucherPNG::setPng()
     * @uses SpeedexVoucherPNG::setVoucherID()
     * @param string $png
     * @param string $voucherID
     */
    public function __construct($png = null, $voucherID = null)
    {
        $this
            ->setPng($png)
            ->setVoucherID($voucherID);
    }
    /**
     * Get png value
     * @return string|null
     */
    public function getPng()
    {
        return $this->png;
    }
    /**
     * Set png value
     * @param string $png
     * @return \Speedex\SpeedexStruct\SpeedexVoucherPNG
     */
    public function setPng($png = null)
    {
        // validation for constraint: string
        if (!is_null($png) && !is_string($png)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($png, true), gettype($png)), __LINE__);
        }
        $this->png = $png;
        return $this;
    }
    /**
     * Get VoucherID value
     * @return string|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param string $voucherID
     * @return \Speedex\SpeedexStruct\SpeedexVoucherPNG
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: string
        if (!is_null($voucherID) && !is_string($voucherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
}
