<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pickup SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexPickup extends AbstractStructBase
{
    /**
     * The ConsignmentNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfString
     */
    public $ConsignmentNumbers;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventCode;
    /**
     * The EventGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventGroupCode;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The PickupAdress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupAdress;
    /**
     * The PickupCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupCity;
    /**
     * The PickupCountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupCountryCode;
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupDate;
    /**
     * The PickupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupName;
    /**
     * The PickupPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupPhoneNumber;
    /**
     * The PickupPostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupPostCode;
    /**
     * The PickupTimeFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupTimeFrom;
    /**
     * The PickupTimeTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupTimeTo;
    /**
     * Constructor method for Pickup
     * @uses SpeedexPickup::setConsignmentNumbers()
     * @uses SpeedexPickup::setEventCode()
     * @uses SpeedexPickup::setEventGroupCode()
     * @uses SpeedexPickup::setNumber()
     * @uses SpeedexPickup::setPickupAdress()
     * @uses SpeedexPickup::setPickupCity()
     * @uses SpeedexPickup::setPickupCountryCode()
     * @uses SpeedexPickup::setPickupDate()
     * @uses SpeedexPickup::setPickupName()
     * @uses SpeedexPickup::setPickupPhoneNumber()
     * @uses SpeedexPickup::setPickupPostCode()
     * @uses SpeedexPickup::setPickupTimeFrom()
     * @uses SpeedexPickup::setPickupTimeTo()
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers
     * @param string $eventCode
     * @param string $eventGroupCode
     * @param string $number
     * @param string $pickupAdress
     * @param string $pickupCity
     * @param string $pickupCountryCode
     * @param string $pickupDate
     * @param string $pickupName
     * @param string $pickupPhoneNumber
     * @param string $pickupPostCode
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     */
    public function __construct(\Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers = null, $eventCode = null, $eventGroupCode = null, $number = null, $pickupAdress = null, $pickupCity = null, $pickupCountryCode = null, $pickupDate = null, $pickupName = null, $pickupPhoneNumber = null, $pickupPostCode = null, $pickupTimeFrom = null, $pickupTimeTo = null)
    {
        $this
            ->setConsignmentNumbers($consignmentNumbers)
            ->setEventCode($eventCode)
            ->setEventGroupCode($eventGroupCode)
            ->setNumber($number)
            ->setPickupAdress($pickupAdress)
            ->setPickupCity($pickupCity)
            ->setPickupCountryCode($pickupCountryCode)
            ->setPickupDate($pickupDate)
            ->setPickupName($pickupName)
            ->setPickupPhoneNumber($pickupPhoneNumber)
            ->setPickupPostCode($pickupPostCode)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo);
    }
    /**
     * Get ConsignmentNumbers value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfString|null
     */
    public function getConsignmentNumbers()
    {
        return $this->ConsignmentNumbers;
    }
    /**
     * Set ConsignmentNumbers value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setConsignmentNumbers(\Speedex\SpeedexArray\SpeedexArrayOfString $consignmentNumbers = null)
    {
        $this->ConsignmentNumbers = $consignmentNumbers;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventGroupCode value
     * @return string|null
     */
    public function getEventGroupCode()
    {
        return $this->EventGroupCode;
    }
    /**
     * Set EventGroupCode value
     * @param string $eventGroupCode
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setEventGroupCode($eventGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventGroupCode) && !is_string($eventGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGroupCode, true), gettype($eventGroupCode)), __LINE__);
        }
        $this->EventGroupCode = $eventGroupCode;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get PickupAdress value
     * @return string|null
     */
    public function getPickupAdress()
    {
        return $this->PickupAdress;
    }
    /**
     * Set PickupAdress value
     * @param string $pickupAdress
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupAdress($pickupAdress = null)
    {
        // validation for constraint: string
        if (!is_null($pickupAdress) && !is_string($pickupAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupAdress, true), gettype($pickupAdress)), __LINE__);
        }
        $this->PickupAdress = $pickupAdress;
        return $this;
    }
    /**
     * Get PickupCity value
     * @return string|null
     */
    public function getPickupCity()
    {
        return $this->PickupCity;
    }
    /**
     * Set PickupCity value
     * @param string $pickupCity
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupCity($pickupCity = null)
    {
        // validation for constraint: string
        if (!is_null($pickupCity) && !is_string($pickupCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupCity, true), gettype($pickupCity)), __LINE__);
        }
        $this->PickupCity = $pickupCity;
        return $this;
    }
    /**
     * Get PickupCountryCode value
     * @return string|null
     */
    public function getPickupCountryCode()
    {
        return $this->PickupCountryCode;
    }
    /**
     * Set PickupCountryCode value
     * @param string $pickupCountryCode
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupCountryCode($pickupCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickupCountryCode) && !is_string($pickupCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupCountryCode, true), gettype($pickupCountryCode)), __LINE__);
        }
        $this->PickupCountryCode = $pickupCountryCode;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get PickupName value
     * @return string|null
     */
    public function getPickupName()
    {
        return $this->PickupName;
    }
    /**
     * Set PickupName value
     * @param string $pickupName
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupName($pickupName = null)
    {
        // validation for constraint: string
        if (!is_null($pickupName) && !is_string($pickupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupName, true), gettype($pickupName)), __LINE__);
        }
        $this->PickupName = $pickupName;
        return $this;
    }
    /**
     * Get PickupPhoneNumber value
     * @return string|null
     */
    public function getPickupPhoneNumber()
    {
        return $this->PickupPhoneNumber;
    }
    /**
     * Set PickupPhoneNumber value
     * @param string $pickupPhoneNumber
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupPhoneNumber($pickupPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pickupPhoneNumber) && !is_string($pickupPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupPhoneNumber, true), gettype($pickupPhoneNumber)), __LINE__);
        }
        $this->PickupPhoneNumber = $pickupPhoneNumber;
        return $this;
    }
    /**
     * Get PickupPostCode value
     * @return string|null
     */
    public function getPickupPostCode()
    {
        return $this->PickupPostCode;
    }
    /**
     * Set PickupPostCode value
     * @param string $pickupPostCode
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupPostCode($pickupPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickupPostCode) && !is_string($pickupPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupPostCode, true), gettype($pickupPostCode)), __LINE__);
        }
        $this->PickupPostCode = $pickupPostCode;
        return $this;
    }
    /**
     * Get PickupTimeFrom value
     * @return string|null
     */
    public function getPickupTimeFrom()
    {
        return $this->PickupTimeFrom;
    }
    /**
     * Set PickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeFrom) && !is_string($pickupTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeFrom, true), gettype($pickupTimeFrom)), __LINE__);
        }
        $this->PickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get PickupTimeTo value
     * @return string|null
     */
    public function getPickupTimeTo()
    {
        return $this->PickupTimeTo;
    }
    /**
     * Set PickupTimeTo value
     * @param string $pickupTimeTo
     * @return \Speedex\SpeedexStruct\SpeedexPickup
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeTo) && !is_string($pickupTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeTo, true), gettype($pickupTimeTo)), __LINE__);
        }
        $this->PickupTimeTo = $pickupTimeTo;
        return $this;
    }
}
