<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTraceByClientKey SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetTraceByClientKey extends AbstractStructBase
{
    /**
     * The sessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionID;
    /**
     * The ClientKey1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientKey1;
    /**
     * The ClientKey2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientKey2;
    /**
     * The ClientKey3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientKey3;
    /**
     * Constructor method for GetTraceByClientKey
     * @uses SpeedexGetTraceByClientKey::setSessionID()
     * @uses SpeedexGetTraceByClientKey::setClientKey1()
     * @uses SpeedexGetTraceByClientKey::setClientKey2()
     * @uses SpeedexGetTraceByClientKey::setClientKey3()
     * @param string $sessionID
     * @param string $clientKey1
     * @param string $clientKey2
     * @param string $clientKey3
     */
    public function __construct($sessionID = null, $clientKey1 = null, $clientKey2 = null, $clientKey3 = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setClientKey1($clientKey1)
            ->setClientKey2($clientKey2)
            ->setClientKey3($clientKey3);
    }
    /**
     * Get sessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }
    /**
     * Set sessionID value
     * @param string $sessionID
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByClientKey
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->sessionID = $sessionID;
        return $this;
    }
    /**
     * Get ClientKey1 value
     * @return string|null
     */
    public function getClientKey1()
    {
        return $this->ClientKey1;
    }
    /**
     * Set ClientKey1 value
     * @param string $clientKey1
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByClientKey
     */
    public function setClientKey1($clientKey1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientKey1) && !is_string($clientKey1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientKey1, true), gettype($clientKey1)), __LINE__);
        }
        $this->ClientKey1 = $clientKey1;
        return $this;
    }
    /**
     * Get ClientKey2 value
     * @return string|null
     */
    public function getClientKey2()
    {
        return $this->ClientKey2;
    }
    /**
     * Set ClientKey2 value
     * @param string $clientKey2
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByClientKey
     */
    public function setClientKey2($clientKey2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientKey2) && !is_string($clientKey2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientKey2, true), gettype($clientKey2)), __LINE__);
        }
        $this->ClientKey2 = $clientKey2;
        return $this;
    }
    /**
     * Get ClientKey3 value
     * @return string|null
     */
    public function getClientKey3()
    {
        return $this->ClientKey3;
    }
    /**
     * Set ClientKey3 value
     * @param string $clientKey3
     * @return \Speedex\SpeedexStruct\SpeedexGetTraceByClientKey
     */
    public function setClientKey3($clientKey3 = null)
    {
        // validation for constraint: string
        if (!is_null($clientKey3) && !is_string($clientKey3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientKey3, true), gettype($clientKey3)), __LINE__);
        }
        $this->ClientKey3 = $clientKey3;
        return $this;
    }
}
