<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBranchesResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetBranchesResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The Branches
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Speedex\SpeedexArray\SpeedexArrayOfBranch
     */
    public $Branches;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetBranchesResponse
     * @uses SpeedexGetBranchesResponse::setReturnCode()
     * @uses SpeedexGetBranchesResponse::setBranches()
     * @uses SpeedexGetBranchesResponse::setReturnMessage()
     * @param int $returnCode
     * @param \Speedex\SpeedexArray\SpeedexArrayOfBranch $branches
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, \Speedex\SpeedexArray\SpeedexArrayOfBranch $branches = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setBranches($branches)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexGetBranchesResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get Branches value
     * @return \Speedex\SpeedexArray\SpeedexArrayOfBranch|null
     */
    public function getBranches()
    {
        return $this->Branches;
    }
    /**
     * Set Branches value
     * @param \Speedex\SpeedexArray\SpeedexArrayOfBranch $branches
     * @return \Speedex\SpeedexStruct\SpeedexGetBranchesResponse
     */
    public function setBranches(\Speedex\SpeedexArray\SpeedexArrayOfBranch $branches = null)
    {
        $this->Branches = $branches;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexGetBranchesResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
