<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderCheckPoint SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexOrderCheckPoint extends AbstractStructBase
{
    /**
     * The CheckpointDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CheckpointDate;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Branch;
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderID;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDesc;
    /**
     * Constructor method for OrderCheckPoint
     * @uses SpeedexOrderCheckPoint::setCheckpointDate()
     * @uses SpeedexOrderCheckPoint::setBranch()
     * @uses SpeedexOrderCheckPoint::setOrderID()
     * @uses SpeedexOrderCheckPoint::setStatusCode()
     * @uses SpeedexOrderCheckPoint::setStatusDesc()
     * @param string $checkpointDate
     * @param string $branch
     * @param string $orderID
     * @param string $statusCode
     * @param string $statusDesc
     */
    public function __construct($checkpointDate = null, $branch = null, $orderID = null, $statusCode = null, $statusDesc = null)
    {
        $this
            ->setCheckpointDate($checkpointDate)
            ->setBranch($branch)
            ->setOrderID($orderID)
            ->setStatusCode($statusCode)
            ->setStatusDesc($statusDesc);
    }
    /**
     * Get CheckpointDate value
     * @return string
     */
    public function getCheckpointDate()
    {
        return $this->CheckpointDate;
    }
    /**
     * Set CheckpointDate value
     * @param string $checkpointDate
     * @return \Speedex\SpeedexStruct\SpeedexOrderCheckPoint
     */
    public function setCheckpointDate($checkpointDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkpointDate) && !is_string($checkpointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkpointDate, true), gettype($checkpointDate)), __LINE__);
        }
        $this->CheckpointDate = $checkpointDate;
        return $this;
    }
    /**
     * Get Branch value
     * @return string|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param string $branch
     * @return \Speedex\SpeedexStruct\SpeedexOrderCheckPoint
     */
    public function setBranch($branch = null)
    {
        // validation for constraint: string
        if (!is_null($branch) && !is_string($branch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branch, true), gettype($branch)), __LINE__);
        }
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get orderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param string $orderID
     * @return \Speedex\SpeedexStruct\SpeedexOrderCheckPoint
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Speedex\SpeedexStruct\SpeedexOrderCheckPoint
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusDesc value
     * @return string|null
     */
    public function getStatusDesc()
    {
        return $this->StatusDesc;
    }
    /**
     * Set StatusDesc value
     * @param string $statusDesc
     * @return \Speedex\SpeedexStruct\SpeedexOrderCheckPoint
     */
    public function setStatusDesc($statusDesc = null)
    {
        // validation for constraint: string
        if (!is_null($statusDesc) && !is_string($statusDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDesc, true), gettype($statusDesc)), __LINE__);
        }
        $this->StatusDesc = $statusDesc;
        return $this;
    }
}
