<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherFromCustomerKeyResponse SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexGetVoucherFromCustomerKeyResponse extends AbstractStructBase
{
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $returnCode;
    /**
     * The voucher_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucher_code;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetVoucherFromCustomerKeyResponse
     * @uses SpeedexGetVoucherFromCustomerKeyResponse::setReturnCode()
     * @uses SpeedexGetVoucherFromCustomerKeyResponse::setVoucher_code()
     * @uses SpeedexGetVoucherFromCustomerKeyResponse::setReturnMessage()
     * @param int $returnCode
     * @param string $voucher_code
     * @param string $returnMessage
     */
    public function __construct($returnCode = null, $voucher_code = null, $returnMessage = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setVoucher_code($voucher_code)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get returnCode value
     * @return int
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param int $returnCode
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKeyResponse
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: int
        if (!is_null($returnCode) && !(is_int($returnCode) || ctype_digit($returnCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get voucher_code value
     * @return string|null
     */
    public function getVoucher_code()
    {
        return $this->voucher_code;
    }
    /**
     * Set voucher_code value
     * @param string $voucher_code
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKeyResponse
     */
    public function setVoucher_code($voucher_code = null)
    {
        // validation for constraint: string
        if (!is_null($voucher_code) && !is_string($voucher_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher_code, true), gettype($voucher_code)), __LINE__);
        }
        $this->voucher_code = $voucher_code;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \Speedex\SpeedexStruct\SpeedexGetVoucherFromCustomerKeyResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
