<?php

namespace Speedex\SpeedexStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Branch SpeedexStruct
 * @package Speedex
 * @subpackage Structs
 */
class SpeedexBranch extends AbstractStructBase
{
    /**
     * The BranchAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchAddress;
    /**
     * The BranchCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCity;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * The BranchTelephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchTelephone;
    /**
     * The BranchZipcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchZipcode;
    /**
     * The pointX
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pointX;
    /**
     * The pointY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pointY;
    /**
     * Constructor method for Branch
     * @uses SpeedexBranch::setBranchAddress()
     * @uses SpeedexBranch::setBranchCity()
     * @uses SpeedexBranch::setBranchCode()
     * @uses SpeedexBranch::setBranchName()
     * @uses SpeedexBranch::setBranchTelephone()
     * @uses SpeedexBranch::setBranchZipcode()
     * @uses SpeedexBranch::setPointX()
     * @uses SpeedexBranch::setPointY()
     * @param string $branchAddress
     * @param string $branchCity
     * @param string $branchCode
     * @param string $branchName
     * @param string $branchTelephone
     * @param string $branchZipcode
     * @param string $pointX
     * @param string $pointY
     */
    public function __construct($branchAddress = null, $branchCity = null, $branchCode = null, $branchName = null, $branchTelephone = null, $branchZipcode = null, $pointX = null, $pointY = null)
    {
        $this
            ->setBranchAddress($branchAddress)
            ->setBranchCity($branchCity)
            ->setBranchCode($branchCode)
            ->setBranchName($branchName)
            ->setBranchTelephone($branchTelephone)
            ->setBranchZipcode($branchZipcode)
            ->setPointX($pointX)
            ->setPointY($pointY);
    }
    /**
     * Get BranchAddress value
     * @return string|null
     */
    public function getBranchAddress()
    {
        return $this->BranchAddress;
    }
    /**
     * Set BranchAddress value
     * @param string $branchAddress
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setBranchAddress($branchAddress = null)
    {
        // validation for constraint: string
        if (!is_null($branchAddress) && !is_string($branchAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchAddress, true), gettype($branchAddress)), __LINE__);
        }
        $this->BranchAddress = $branchAddress;
        return $this;
    }
    /**
     * Get BranchCity value
     * @return string|null
     */
    public function getBranchCity()
    {
        return $this->BranchCity;
    }
    /**
     * Set BranchCity value
     * @param string $branchCity
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setBranchCity($branchCity = null)
    {
        // validation for constraint: string
        if (!is_null($branchCity) && !is_string($branchCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCity, true), gettype($branchCity)), __LINE__);
        }
        $this->BranchCity = $branchCity;
        return $this;
    }
    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }
    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
    /**
     * Get BranchTelephone value
     * @return string|null
     */
    public function getBranchTelephone()
    {
        return $this->BranchTelephone;
    }
    /**
     * Set BranchTelephone value
     * @param string $branchTelephone
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setBranchTelephone($branchTelephone = null)
    {
        // validation for constraint: string
        if (!is_null($branchTelephone) && !is_string($branchTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchTelephone, true), gettype($branchTelephone)), __LINE__);
        }
        $this->BranchTelephone = $branchTelephone;
        return $this;
    }
    /**
     * Get BranchZipcode value
     * @return string|null
     */
    public function getBranchZipcode()
    {
        return $this->BranchZipcode;
    }
    /**
     * Set BranchZipcode value
     * @param string $branchZipcode
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setBranchZipcode($branchZipcode = null)
    {
        // validation for constraint: string
        if (!is_null($branchZipcode) && !is_string($branchZipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchZipcode, true), gettype($branchZipcode)), __LINE__);
        }
        $this->BranchZipcode = $branchZipcode;
        return $this;
    }
    /**
     * Get pointX value
     * @return string|null
     */
    public function getPointX()
    {
        return $this->pointX;
    }
    /**
     * Set pointX value
     * @param string $pointX
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setPointX($pointX = null)
    {
        // validation for constraint: string
        if (!is_null($pointX) && !is_string($pointX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointX, true), gettype($pointX)), __LINE__);
        }
        $this->pointX = $pointX;
        return $this;
    }
    /**
     * Get pointY value
     * @return string|null
     */
    public function getPointY()
    {
        return $this->pointY;
    }
    /**
     * Set pointY value
     * @param string $pointY
     * @return \Speedex\SpeedexStruct\SpeedexBranch
     */
    public function setPointY($pointY = null)
    {
        // validation for constraint: string
        if (!is_null($pointY) && !is_string($pointY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointY, true), gettype($pointY)), __LINE__);
        }
        $this->pointY = $pointY;
        return $this;
    }
}
