<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RichiestaRimuoviPosizione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RichiestaRimuoviPosizione
 * @subpackage Structs
 */
class RichiestaRimuoviPosizione extends FeedAuthenticatedRequestBase
{
    /**
     * The CodiceEnte
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceEnte;
    /**
     * The CodiceIdentificativo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceIdentificativo;
    /**
     * Constructor method for RichiestaRimuoviPosizione
     * @uses RichiestaRimuoviPosizione::setCodiceEnte()
     * @uses RichiestaRimuoviPosizione::setCodiceIdentificativo()
     * @param string $codiceEnte
     * @param string $codiceIdentificativo
     */
    public function __construct($codiceEnte = null, $codiceIdentificativo = null)
    {
        $this
            ->setCodiceEnte($codiceEnte)
            ->setCodiceIdentificativo($codiceIdentificativo);
    }
    /**
     * Get CodiceEnte value
     * @return string|null
     */
    public function getCodiceEnte()
    {
        return $this->CodiceEnte;
    }
    /**
     * Set CodiceEnte value
     * @param string $codiceEnte
     * @return \pagopa.efil\StructType\RichiestaRimuoviPosizione
     */
    public function setCodiceEnte($codiceEnte = null)
    {
        // validation for constraint: string
        if (!is_null($codiceEnte) && !is_string($codiceEnte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceEnte, true), gettype($codiceEnte)), __LINE__);
        }
        $this->CodiceEnte = $codiceEnte;
        return $this;
    }
    /**
     * Get CodiceIdentificativo value
     * @return string|null
     */
    public function getCodiceIdentificativo()
    {
        return $this->CodiceIdentificativo;
    }
    /**
     * Set CodiceIdentificativo value
     * @param string $codiceIdentificativo
     * @return \pagopa.efil\StructType\RichiestaRimuoviPosizione
     */
    public function setCodiceIdentificativo($codiceIdentificativo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIdentificativo) && !is_string($codiceIdentificativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceIdentificativo, true), gettype($codiceIdentificativo)), __LINE__);
        }
        $this->CodiceIdentificativo = $codiceIdentificativo;
        return $this;
    }
}
