<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Nazione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Nazione
 * @subpackage Structs
 */
class Nazione extends AbstractStructBase
{
    /**
     * The CodiceIsoNazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceIsoNazione;
    /**
     * The NomeNazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeNazione;
    /**
     * Constructor method for Nazione
     * @uses Nazione::setCodiceIsoNazione()
     * @uses Nazione::setNomeNazione()
     * @param string $codiceIsoNazione
     * @param string $nomeNazione
     */
    public function __construct($codiceIsoNazione = null, $nomeNazione = null)
    {
        $this
            ->setCodiceIsoNazione($codiceIsoNazione)
            ->setNomeNazione($nomeNazione);
    }
    /**
     * Get CodiceIsoNazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceIsoNazione()
    {
        return isset($this->CodiceIsoNazione) ? $this->CodiceIsoNazione : null;
    }
    /**
     * Set CodiceIsoNazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceIsoNazione
     * @return \pagopa.efil\StructType\Nazione
     */
    public function setCodiceIsoNazione($codiceIsoNazione = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIsoNazione) && !is_string($codiceIsoNazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceIsoNazione, true), gettype($codiceIsoNazione)), __LINE__);
        }
        if (is_null($codiceIsoNazione) || (is_array($codiceIsoNazione) && empty($codiceIsoNazione))) {
            unset($this->CodiceIsoNazione);
        } else {
            $this->CodiceIsoNazione = $codiceIsoNazione;
        }
        return $this;
    }
    /**
     * Get NomeNazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeNazione()
    {
        return isset($this->NomeNazione) ? $this->NomeNazione : null;
    }
    /**
     * Set NomeNazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeNazione
     * @return \pagopa.efil\StructType\Nazione
     */
    public function setNomeNazione($nomeNazione = null)
    {
        // validation for constraint: string
        if (!is_null($nomeNazione) && !is_string($nomeNazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeNazione, true), gettype($nomeNazione)), __LINE__);
        }
        if (is_null($nomeNazione) || (is_array($nomeNazione) && empty($nomeNazione))) {
            unset($this->NomeNazione);
        } else {
            $this->NomeNazione = $nomeNazione;
        }
        return $this;
    }
}
