<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \pagopa.efil\ClassMap::get(),
);
/**
 * Samples for Carica ServiceType
 */
$carica = new \pagopa.efil\ServiceType\Carica($options);
$carica->setSoapHeaderIdApplicazione($IdApplicazione);
$carica->setSoapHeaderUserName($UserName);
/**
 * Sample call for CaricaPosizione operation/method
 */
if ($carica->CaricaPosizione(new \pagopa.efil\StructType\CaricaPosizione()) !== false) {
    print_r($carica->getResult());
} else {
    print_r($carica->getLastError());
}
/**
 * Sample call for CaricaPosizioneConEsitoArricchito operation/method
 */
if ($carica->CaricaPosizioneConEsitoArricchito(new \pagopa.efil\StructType\CaricaPosizioneConEsitoArricchito()) !== false) {
    print_r($carica->getResult());
} else {
    print_r($carica->getLastError());
}
/**
 * Sample call for CaricaPosizioni operation/method
 */
if ($carica->CaricaPosizioni(new \pagopa.efil\StructType\CaricaPosizioni()) !== false) {
    print_r($carica->getResult());
} else {
    print_r($carica->getLastError());
}
/**
 * Sample call for CaricaPosizionePagata operation/method
 */
if ($carica->CaricaPosizionePagata(new \pagopa.efil\StructType\PosizionePagata()) !== false) {
    print_r($carica->getResult());
} else {
    print_r($carica->getLastError());
}
/**
 * Samples for Valida ServiceType
 */
$valida = new \pagopa.efil\ServiceType\Valida($options);
/**
 * Sample call for ValidaPosizioni operation/method
 */
if ($valida->ValidaPosizioni(new \pagopa.efil\StructType\ValidaPosizioni()) !== false) {
    print_r($valida->getResult());
} else {
    print_r($valida->getLastError());
}
/**
 * Samples for Rettifica ServiceType
 */
$rettifica = new \pagopa.efil\ServiceType\Rettifica($options);
/**
 * Sample call for RettificaPosizione operation/method
 */
if ($rettifica->RettificaPosizione(new \pagopa.efil\StructType\RettificaPosizione()) !== false) {
    print_r($rettifica->getResult());
} else {
    print_r($rettifica->getLastError());
}
/**
 * Samples for Rimuovi ServiceType
 */
$rimuovi = new \pagopa.efil\ServiceType\Rimuovi($options);
/**
 * Sample call for RimuoviPosizione operation/method
 */
if ($rimuovi->RimuoviPosizione(new \pagopa.efil\StructType\RimuoviPosizione()) !== false) {
    print_r($rimuovi->getResult());
} else {
    print_r($rimuovi->getLastError());
}
