<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Servizio StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Servizio
 * @subpackage Structs
 */
class Servizio extends AbstractStructBase
{
    /**
     * The CodiceServizio
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceServizio;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * Constructor method for Servizio
     * @uses Servizio::setCodiceServizio()
     * @uses Servizio::setDescrizione()
     * @param string $codiceServizio
     * @param string $descrizione
     */
    public function __construct($codiceServizio = null, $descrizione = null)
    {
        $this
            ->setCodiceServizio($codiceServizio)
            ->setDescrizione($descrizione);
    }
    /**
     * Get CodiceServizio value
     * @return string|null
     */
    public function getCodiceServizio()
    {
        return $this->CodiceServizio;
    }
    /**
     * Set CodiceServizio value
     * @param string $codiceServizio
     * @return \pagopa.efil\StructType\Servizio
     */
    public function setCodiceServizio($codiceServizio = null)
    {
        // validation for constraint: string
        if (!is_null($codiceServizio) && !is_string($codiceServizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceServizio, true), gettype($codiceServizio)), __LINE__);
        }
        $this->CodiceServizio = $codiceServizio;
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \pagopa.efil\StructType\Servizio
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
}
