<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Creditore StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Creditore
 * @subpackage Structs
 */
class Creditore extends AbstractStructBase
{
    /**
     * The CodiceEnte
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceEnte;
    /**
     * The CodiceFiscalePartitaIva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceFiscalePartitaIva;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The Intestazione
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Intestazione;
    /**
     * Constructor method for Creditore
     * @uses Creditore::setCodiceEnte()
     * @uses Creditore::setCodiceFiscalePartitaIva()
     * @uses Creditore::setIBAN()
     * @uses Creditore::setIntestazione()
     * @param string $codiceEnte
     * @param string $codiceFiscalePartitaIva
     * @param string $iBAN
     * @param string $intestazione
     */
    public function __construct($codiceEnte = null, $codiceFiscalePartitaIva = null, $iBAN = null, $intestazione = null)
    {
        $this
            ->setCodiceEnte($codiceEnte)
            ->setCodiceFiscalePartitaIva($codiceFiscalePartitaIva)
            ->setIBAN($iBAN)
            ->setIntestazione($intestazione);
    }
    /**
     * Get CodiceEnte value
     * @return string|null
     */
    public function getCodiceEnte()
    {
        return $this->CodiceEnte;
    }
    /**
     * Set CodiceEnte value
     * @param string $codiceEnte
     * @return \pagopa.efil\StructType\Creditore
     */
    public function setCodiceEnte($codiceEnte = null)
    {
        // validation for constraint: string
        if (!is_null($codiceEnte) && !is_string($codiceEnte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceEnte, true), gettype($codiceEnte)), __LINE__);
        }
        $this->CodiceEnte = $codiceEnte;
        return $this;
    }
    /**
     * Get CodiceFiscalePartitaIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceFiscalePartitaIva()
    {
        return isset($this->CodiceFiscalePartitaIva) ? $this->CodiceFiscalePartitaIva : null;
    }
    /**
     * Set CodiceFiscalePartitaIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceFiscalePartitaIva
     * @return \pagopa.efil\StructType\Creditore
     */
    public function setCodiceFiscalePartitaIva($codiceFiscalePartitaIva = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscalePartitaIva) && !is_string($codiceFiscalePartitaIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscalePartitaIva, true), gettype($codiceFiscalePartitaIva)), __LINE__);
        }
        if (is_null($codiceFiscalePartitaIva) || (is_array($codiceFiscalePartitaIva) && empty($codiceFiscalePartitaIva))) {
            unset($this->CodiceFiscalePartitaIva);
        } else {
            $this->CodiceFiscalePartitaIva = $codiceFiscalePartitaIva;
        }
        return $this;
    }
    /**
     * Get IBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * Set IBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBAN
     * @return \pagopa.efil\StructType\Creditore
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get Intestazione value
     * @return string|null
     */
    public function getIntestazione()
    {
        return $this->Intestazione;
    }
    /**
     * Set Intestazione value
     * @param string $intestazione
     * @return \pagopa.efil\StructType\Creditore
     */
    public function setIntestazione($intestazione = null)
    {
        // validation for constraint: string
        if (!is_null($intestazione) && !is_string($intestazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intestazione, true), gettype($intestazione)), __LINE__);
        }
        $this->Intestazione = $intestazione;
        return $this;
    }
}
